/*
 * Decompiled with CFR 0.152.
 */
package org.basicmon;

import java.util.SortedMap;
import java.util.TreeMap;
import org.basicmon.BasicCounter;
import org.basicmon.BasicMon;
import org.basicmon.BasicTimer;
import org.basicmon.atomic.BasicCounterAtomicImpl;
import org.basicmon.atomic.BasicTimerAtomicImpl;
import org.basicmon.sync.BasicCounterSyncImpl;
import org.basicmon.sync.BasicTimerSyncImpl;

public final class BasicMonManager {
    private static final BasicMonManager manager = new BasicMonManager();
    private final SortedMap<String, BasicTimer> timers = new TreeMap<String, BasicTimer>();
    private final SortedMap<String, BasicCounter> counters = new TreeMap<String, BasicCounter>();

    public static BasicTimer getTimer(String id) {
        return manager.doGetSyncTimer(id, false);
    }

    public static BasicTimer getTimerWithStats(String id) {
        return manager.doGetSyncTimer(id, true);
    }

    public static BasicTimer getTimer(String id, boolean withStats) {
        return manager.doGetSyncTimer(id, withStats);
    }

    public static BasicTimer getSyncTimer(String id) {
        return manager.doGetSyncTimer(id, false);
    }

    public static BasicTimer getSyncTimerWithStats(String id) {
        return manager.doGetSyncTimer(id, true);
    }

    public static BasicTimer getSyncTimer(String id, boolean withStats) {
        return manager.doGetSyncTimer(id, withStats);
    }

    public static BasicTimer getAtomicTimer(String id) {
        return manager.doGetAtomicTimer(id, false);
    }

    public static BasicTimer getAtomicTimerWithStats(String id) {
        return manager.doGetAtomicTimer(id, true);
    }

    public static BasicTimer getAtomicTimer(String id, boolean withStats) {
        return manager.doGetAtomicTimer(id, withStats);
    }

    public static BasicCounter getCounter(String id) {
        return manager.doGetSyncCounter(id, false);
    }

    public static BasicCounter getCounterWithStats(String id) {
        return manager.doGetSyncCounter(id, true);
    }

    public static BasicCounter getCounter(String id, boolean withStats) {
        return manager.doGetSyncCounter(id, withStats);
    }

    public static BasicCounter getSyncCounter(String id) {
        return manager.doGetSyncCounter(id, false);
    }

    public static BasicCounter getSyncCounterWithStats(String id) {
        return manager.doGetSyncCounter(id, true);
    }

    public static BasicCounter getSyncCounter(String id, boolean withStats) {
        return manager.doGetSyncCounter(id, withStats);
    }

    public static BasicCounter getAtomicCounter(String id) {
        return manager.doGetAtomicCounter(id, false);
    }

    public static BasicCounter getAtomicCounterWithStats(String id) {
        return manager.doGetAtomicCounter(id, true);
    }

    public static BasicCounter getAtomicCounter(String id, boolean withStats) {
        return manager.doGetAtomicCounter(id, withStats);
    }

    public static String prettyPrint() {
        return manager.doPrettyPrint();
    }

    public static void reset() {
        manager.doReset();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private BasicTimer doGetAtomicTimer(String id, boolean withStats) {
        SortedMap<String, BasicTimer> sortedMap = this.timers;
        synchronized (sortedMap) {
            BasicTimerAtomicImpl timer = (BasicTimerAtomicImpl)this.timers.get(id);
            if (timer == null) {
                timer = new BasicTimerAtomicImpl(id, withStats);
                this.timers.put(id, timer);
            }
            return timer;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private BasicTimer doGetSyncTimer(String id, boolean withStats) {
        SortedMap<String, BasicTimer> sortedMap = this.timers;
        synchronized (sortedMap) {
            BasicTimerSyncImpl timer = (BasicTimerSyncImpl)this.timers.get(id);
            if (timer == null) {
                timer = new BasicTimerSyncImpl(id, withStats);
                this.timers.put(id, timer);
            }
            return timer;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private BasicCounter doGetAtomicCounter(String id, boolean withStats) {
        SortedMap<String, BasicCounter> sortedMap = this.counters;
        synchronized (sortedMap) {
            BasicCounter counter = (BasicCounter)this.counters.get(id);
            if (counter == null) {
                counter = new BasicCounterAtomicImpl(id, withStats);
                this.counters.put(id, counter);
            }
            return counter;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private BasicCounter doGetSyncCounter(String id, boolean withStats) {
        SortedMap<String, BasicCounter> sortedMap = this.counters;
        synchronized (sortedMap) {
            BasicCounter counter = (BasicCounter)this.counters.get(id);
            if (counter == null) {
                counter = new BasicCounterSyncImpl(id, withStats);
                this.counters.put(id, counter);
            }
            return counter;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String doPrettyPrint() {
        StringBuilder s = new StringBuilder(1024);
        s.append("BasicTimers:\n");
        SortedMap<String, BasicMon> sortedMap = this.timers;
        synchronized (sortedMap) {
            for (BasicTimer basicTimer : this.timers.values()) {
                s.append("\t").append(basicTimer.toString()).append("\n");
            }
        }
        s.append("\nBasicCounters:\n");
        sortedMap = this.counters;
        synchronized (sortedMap) {
            for (BasicMon basicMon : this.counters.values()) {
                s.append("\t").append(basicMon.toString()).append("\n");
            }
        }
        return s.toString();
    }

    private synchronized void doReset() {
        this.timers.clear();
        this.counters.clear();
    }
}

