/*
 * Decompiled with CFR 0.152.
 */
package org.basicmon.atomic;

import java.util.concurrent.atomic.AtomicLong;
import org.basicmon.BasicMonBase;

public abstract class BasicMonAtomicBase
extends BasicMonBase {
    private final AtomicLong val = new AtomicLong(0L);
    private final AtomicLong total = new AtomicLong(0L);
    private final AtomicLong updateCount = new AtomicLong(0L);

    public BasicMonAtomicBase(String id, boolean withStats) {
        super(id, withStats);
    }

    @Override
    public synchronized void reset() {
        this.val.set(0L);
        this.total.set(0L);
        this.updateCount.set(0L);
        super.reset();
    }

    @Override
    public void increment() {
        long current = this.val.incrementAndGet();
        this.total.addAndGet(current);
        this.updateCount.incrementAndGet();
        if (!this.withStats) {
            return;
        }
        this.updateStats(current);
    }

    @Override
    public void decrement() {
        long current = this.val.decrementAndGet();
        this.total.addAndGet(current);
        this.updateCount.incrementAndGet();
        if (!this.withStats) {
            return;
        }
        this.updateStats(current);
    }

    @Override
    public void setVal(long val) {
        this.val.set(val);
        this.total.addAndGet(val);
        this.updateCount.incrementAndGet();
        if (!this.withStats) {
            return;
        }
        this.updateStats(val);
    }

    @Override
    public long getVal() {
        return this.val.get();
    }

    @Override
    public long getTotal() {
        return this.total.get();
    }

    @Override
    public long getUpdateCount() {
        return this.updateCount.get();
    }

    @Override
    public double getMean() {
        return (double)this.total.get() / (double)this.updateCount.get();
    }
}

