/*
 * Decompiled with CFR 0.152.
 */
package org.basicmon.sync;

import org.basicmon.BasicMonBase;

public abstract class BasicMonSyncBase
extends BasicMonBase {
    private long val;
    private long total;
    private long updateCount;

    public BasicMonSyncBase(String id, boolean withStats) {
        super(id, withStats);
    }

    @Override
    public synchronized void reset() {
        this.val = 0L;
        this.total = 0L;
        this.updateCount = 0L;
        super.reset();
    }

    @Override
    public synchronized void increment() {
        long current = ++this.val;
        this.total += current;
        ++this.updateCount;
        if (!this.withStats) {
            return;
        }
        this.updateStats(current);
    }

    @Override
    public synchronized void decrement() {
        long current = --this.val;
        this.total += current;
        ++this.updateCount;
        if (!this.withStats) {
            return;
        }
        this.updateStats(current);
    }

    @Override
    public synchronized void setVal(long val) {
        this.val = val;
        this.total += val;
        ++this.updateCount;
        if (!this.withStats) {
            return;
        }
        this.updateStats(val);
    }

    @Override
    public synchronized long getVal() {
        return this.val;
    }

    @Override
    public synchronized long getTotal() {
        return this.total;
    }

    @Override
    public synchronized long getUpdateCount() {
        return this.updateCount;
    }

    @Override
    public synchronized double getMean() {
        return (double)this.total / (double)this.updateCount;
    }
}

