/*
 * Decompiled with CFR 0.152.
 */
package com.rodbate.httpserver.common;

import com.rodbate.httpserver.common.ServerConfig;
import com.rodbate.httpserver.common.StringUtil;
import java.net.InetAddress;
import java.net.UnknownHostException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NetUtil {
    private static final String hostname = ServerConfig.getProperty("hostname");
    private static final String PORT = ServerConfig.getProperty("port");
    private static final Logger LOGGER = LoggerFactory.getLogger(NetUtil.class);

    public static String getHttpHeaderHost() {
        String host = null;
        if (StringUtil.isNull(hostname)) {
            try {
                host = InetAddress.getLocalHost().getHostName() + ("80".equals(PORT) ? "" : ":" + PORT);
            }
            catch (UnknownHostException e) {
                e.printStackTrace();
                LOGGER.error(e.getMessage(), (Throwable)e);
            }
        } else {
            try {
                host = InetAddress.getByName(hostname).getHostName() + ("80".equals(PORT) ? "" : ":" + PORT);
            }
            catch (UnknownHostException e) {
                e.printStackTrace();
                LOGGER.error(e.getMessage(), (Throwable)e);
            }
        }
        return host;
    }
}

