/*
 * Decompiled with CFR 0.152.
 */
package com.rodbate.httpserver.test;

import com.rodbate.httpserver.common.StringUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.ProtocolException;
import java.net.URL;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

public class SimpleDownloadClient {
    public static final int PROCESSORS = Runtime.getRuntime().availableProcessors();
    static volatile long sum = 0L;
    public static long fileLength;

    public static long getFileLength(String urlStr) {
        HttpURLConnection connection = SimpleDownloadClient.getConnection(urlStr);
        long length = 0L;
        try {
            if (connection != null) {
                connection.setRequestMethod("GET");
                connection.connect();
                fileLength = length = Long.valueOf(connection.getHeaderField("Content-Length")).longValue();
                connection.disconnect();
            }
        }
        catch (ProtocolException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return length;
    }

    public static Map<Integer, List<Long>> handleLengthPerThread(String urlStr) {
        long fileLength = SimpleDownloadClient.getFileLength(urlStr);
        HashMap<Integer, List<Long>> map = new HashMap<Integer, List<Long>>();
        if (fileLength > 0L) {
            if (fileLength % (long)PROCESSORS == 0L) {
                long unit = fileLength / (long)PROCESSORS;
                for (int i = 1; i <= PROCESSORS; ++i) {
                    ArrayList<Long> list = new ArrayList<Long>();
                    long start = (long)(i - 1) * unit;
                    long end = (long)i * unit - 1L;
                    list.add(start);
                    list.add(end);
                    map.put(i, list);
                }
            } else {
                long unit = fileLength / (long)PROCESSORS;
                long remain = fileLength - unit * (long)(PROCESSORS - 1);
                for (int i = 1; i < PROCESSORS; ++i) {
                    ArrayList<Long> list = new ArrayList<Long>();
                    long start = (long)(i - 1) * unit;
                    long end = (long)i * unit - 1L;
                    list.add(start);
                    list.add(end);
                    map.put(i, list);
                }
                ArrayList<Long> list = new ArrayList<Long>();
                long start = fileLength - remain;
                long end = fileLength - 1L;
                list.add(start);
                list.add(end);
                map.put(PROCESSORS, list);
            }
        }
        return map;
    }

    public static synchronized void inc(long size) {
        sum += size;
    }

    public static HttpURLConnection getConnection(String urlStr) {
        try {
            URL url = new URL(urlStr);
            return (HttpURLConnection)url.openConnection();
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return null;
    }

    public static void main(String[] args) throws IOException {
        ExecutorService service = Executors.newFixedThreadPool(PROCESSORS);
        CountDownLatch signal = new CountDownLatch(PROCESSORS);
        String urlStr = "http://file.allitebooks.com/20150615/Getting Started with Impala.pdf";
        Map<Integer, List<Long>> map = SimpleDownloadClient.handleLengthPerThread(urlStr);
        File dir = new File("D:\\temp");
        if (!dir.exists()) {
            dir.mkdirs();
        }
        String[] filename = new String[1];
        int i = 1;
        while (i <= PROCESSORS) {
            int j = i++;
            service.execute(() -> {
                HttpURLConnection connection = SimpleDownloadClient.getConnection(urlStr);
                try {
                    if (connection != null) {
                        connection.setRequestMethod("GET");
                        connection.addRequestProperty("Range", String.format("bytes=%d-%d", ((List)map.get(j)).get(0), ((List)map.get(j)).get(1)));
                        connection.connect();
                        int responseCode = connection.getResponseCode();
                        if (responseCode == 200 || responseCode == 206) {
                            int len;
                            String disposition = connection.getHeaderField("Disposition");
                            System.out.println("============ disposition : " + disposition);
                            filename[0] = StringUtil.isNotNull(disposition) ? disposition.split(";")[1].split("=")[1] : urlStr.substring(urlStr.lastIndexOf("/") + 1);
                            InputStream is = connection.getInputStream();
                            File f = new File("D:\\temp\\temp_" + filename[0] + "_" + j);
                            if (!f.exists()) {
                                f.createNewFile();
                            }
                            FileOutputStream fos = new FileOutputStream(f, true);
                            boolean sum = false;
                            byte[] ba = new byte[1024];
                            while ((len = is.read(ba)) > 0) {
                                SimpleDownloadClient.inc(len);
                                fos.write(ba, 0, len);
                            }
                            fos.close();
                            is.close();
                        }
                        connection.disconnect();
                        signal.countDown();
                    }
                }
                catch (ProtocolException e) {
                    e.printStackTrace();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            });
        }
        final DecimalFormat df = new DecimalFormat("####.00");
        new Thread(){

            @Override
            public void run() {
                double percent;
                do {
                    percent = Double.valueOf(df.format((double)sum * 1.0 / (double)fileLength * 100.0));
                    System.out.println("============== download percent ===== >>> : " + sum + "/" + fileLength + "     " + percent + "%");
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                } while (sum != fileLength);
                System.out.println("============== download percent ===== >>> : " + sum + "/" + fileLength + "     " + percent + "%");
                System.out.println("============ download complete ==== >>>>>");
            }
        }.start();
        try {
            signal.await();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
            Thread.currentThread().interrupt();
        }
        service.shutdown();
        SimpleDownloadClient.gatherTempFiles(dir, "temp_" + filename[0] + "_", filename[0]);
    }

    public static int getIndex(File f) {
        return Integer.valueOf(f.getName().split("_")[2]);
    }

    public static void gatherTempFiles(File dir, String prefix, String target) {
        if (dir.isDirectory()) {
            File file = new File(dir.getAbsolutePath() + File.separator + target);
            try {
                int i;
                FileOutputStream fos = new FileOutputStream(file);
                File[] files = dir.listFiles(pathname -> pathname.isFile() && pathname.getName().startsWith(prefix));
                for (i = 1; i < files.length; ++i) {
                    File temp = files[i];
                    for (int j = i; j > 0 && SimpleDownloadClient.getIndex(files[j]) < SimpleDownloadClient.getIndex(files[j - 1]); --j) {
                        files[j] = files[j - 1];
                    }
                    files[j] = temp;
                }
                for (i = 0; i < files.length; ++i) {
                    int len;
                    FileInputStream fis = new FileInputStream(files[i]);
                    byte[] ba = new byte[1024];
                    while ((len = fis.read(ba)) > 0) {
                        fos.write(ba, 0, len);
                    }
                    fis.close();
                    files[i].delete();
                }
                fos.close();
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public void singleThread() throws IOException {
        URL url = new URL("http://127.0.0.1:8888/1.exe");
        HttpURLConnection urlConnection = (HttpURLConnection)url.openConnection();
        urlConnection.setRequestMethod("GET");
        urlConnection.addRequestProperty("Range", "bytes=0-");
        urlConnection.connect();
        int responseCode = urlConnection.getResponseCode();
        long length = Long.valueOf(urlConnection.getHeaderField("Content-Length"));
        if (responseCode == 200 || responseCode == 206) {
            int len;
            InputStream is = urlConnection.getInputStream();
            File f = new File("D:\\1.exe");
            if (!f.exists()) {
                f.createNewFile();
            }
            FileOutputStream fos = new FileOutputStream(f);
            int sum = 0;
            byte[] ba = new byte[1024];
            while ((len = is.read(ba)) > 0) {
                ++sum;
                fos.write(ba, 0, len);
            }
            fos.close();
            is.close();
        }
        urlConnection.disconnect();
    }
}

