/*
 * Decompiled with CFR 0.152.
 */
package com.rodbate.httpserver.dispatcher;

import com.rodbate.httpserver.dispatcher.AbstractRequestDispatcher;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http.HttpObject;
import java.net.InetSocketAddress;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseRequestDispatcher
extends AbstractRequestDispatcher {
    private static final Logger LOGGER = LoggerFactory.getLogger(BaseRequestDispatcher.class);
    private AtomicInteger C = new AtomicInteger(1);

    @Override
    public void init() {
    }

    public void channelActive(ChannelHandlerContext ctx) throws Exception {
        InetSocketAddress socketAddress = (InetSocketAddress)ctx.channel().remoteAddress();
        LOGGER.info("The remote address is {}", (Object)socketAddress.getHostName());
        super.channelActive(ctx);
    }

    protected void channelRead0(ChannelHandlerContext ctx, HttpObject msg) throws Exception {
        LOGGER.info("====== " + ((Object)((Object)this)).getClass() + "   invoke method channelRead0 count  : " + this.C.getAndIncrement());
        this.dispatch(ctx, msg);
    }

    protected abstract void dispatch(ChannelHandlerContext var1, HttpObject var2) throws Exception;

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        LOGGER.error(cause.getMessage(), cause);
        ctx.channel().close();
    }
}

