/*
 * Decompiled with CFR 0.152.
 */
package com.github.ruediste.c3java.invocationRecording;

import com.github.ruediste.c3java.invocationRecording.MethodInvocation;
import com.google.common.base.Defaults;
import com.google.common.collect.Iterables;
import com.google.common.reflect.TypeToken;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.function.Consumer;
import net.sf.cglib.proxy.Callback;
import net.sf.cglib.proxy.CallbackFilter;
import net.sf.cglib.proxy.Enhancer;
import net.sf.cglib.proxy.MethodInterceptor;
import net.sf.cglib.proxy.MethodProxy;
import net.sf.cglib.proxy.NoOp;

public class MethodInvocationRecorder {
    private final ArrayList<MethodInvocation<Object>> invocations = new ArrayList();
    private static final CallbackFilter FINALIZE_FILTER = new CallbackFilter(){

        public int accept(Method method) {
            if (method.getName().equals("finalize") && method.getParameterTypes().length == 0 && method.getReturnType() == Void.TYPE) {
                return 0;
            }
            return 1;
        }
    };

    public <T> T getProxy(Class<T> type) {
        return this.getProxy(TypeToken.of(type));
    }

    public <T> T getProxy(final TypeToken<T> type) {
        Class cls = type.getRawType();
        if (this.isTerminal(type)) {
            return (T)Defaults.defaultValue((Class)cls);
        }
        Enhancer e = new Enhancer();
        if (Enhancer.isEnhanced((Class)cls)) {
            e.setSuperclass(cls.getSuperclass());
            e.setInterfaces((Class[])cls.getInterfaces());
        } else {
            e.setSuperclass(cls);
        }
        e.setCallbackFilter(FINALIZE_FILTER);
        e.setCallbacks(new Callback[]{NoOp.INSTANCE, new MethodInterceptor(){

            public Object intercept(Object obj, Method method, Object[] args, MethodProxy proxy) throws Throwable {
                MethodInvocationRecorder.this.invocations.add(new MethodInvocation<Object>(type, method, Arrays.asList(args)));
                return MethodInvocationRecorder.this.getProxy(type.resolveType(method.getGenericReturnType()));
            }
        }});
        try {
            return (T)e.create();
        }
        catch (Exception ex) {
            throw new RuntimeException("Error while creating proxy of " + type, ex);
        }
    }

    boolean isTerminal(TypeToken<?> returnType) {
        Class clazz = returnType.getRawType();
        return clazz.isPrimitive() || String.class.equals((Object)clazz) || Date.class.equals((Object)clazz) || clazz.isEnum();
    }

    public List<MethodInvocation<Object>> getInvocations() {
        return Collections.unmodifiableList(this.invocations);
    }

    public MethodInvocation<Object> getLastInvocation() {
        return (MethodInvocation)Iterables.getLast(this.invocations);
    }

    public static <T> List<MethodInvocation<Object>> getInvocations(Class<T> cls, Consumer<T> accessor) {
        return MethodInvocationRecorder.getInvocations(TypeToken.of(cls), accessor);
    }

    public static <T> List<MethodInvocation<Object>> getInvocations(TypeToken<T> cls, Consumer<T> accessor) {
        MethodInvocationRecorder recorder = new MethodInvocationRecorder();
        accessor.accept(recorder.getProxy(cls));
        return recorder.getInvocations();
    }

    public static <T> MethodInvocation<Object> getLastInvocation(Class<T> cls, Consumer<T> accessor) {
        return MethodInvocationRecorder.getLastInvocation(TypeToken.of(cls), accessor);
    }

    public static <T> MethodInvocation<Object> getLastInvocation(TypeToken<T> cls, Consumer<T> accessor) {
        MethodInvocationRecorder recorder = new MethodInvocationRecorder();
        accessor.accept(recorder.getProxy(cls));
        return recorder.getLastInvocation();
    }
}

