/*
 * Decompiled with CFR 0.152.
 */
package com.github.ruediste.c3java.linearization;

import com.github.ruediste.c3java.linearization.DirectSuperclassesInspector;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class DefaultDirectSuperclassesInspector
implements DirectSuperclassesInspector {
    private static final Map<Class<?>, List<Class<?>>> PRIMITIVE_SUPERCLASSES;
    public static final DirectSuperclassesInspector INSTANCE;
    protected static List<Class<?>> ARRAY_SUPERCLASSES;

    private static List<Class<?>> classList(Class<?> ... class1) {
        return Collections.unmodifiableList(Arrays.asList(class1));
    }

    @Override
    public List<Class<?>> directParentClasses(Class<?> c) {
        if (c.isPrimitive()) {
            return DefaultDirectSuperclassesInspector.primitiveSuperclasses(c);
        }
        if (c.isArray()) {
            return DefaultDirectSuperclassesInspector.arrayDirectSuperclasses(0, c, this);
        }
        List<Class<?>> interfaces = Arrays.asList(c.getInterfaces());
        Class<?> superclass = c.getSuperclass();
        if (c == Object.class) {
            return ImmutableList.of();
        }
        if (superclass == null && interfaces.isEmpty()) {
            return DefaultDirectSuperclassesInspector.classList(Object.class);
        }
        if (superclass == Object.class) {
            return Lists.newArrayList((Iterable)Iterables.concat(interfaces, DefaultDirectSuperclassesInspector.classList(Object.class)));
        }
        if (superclass == null) {
            return interfaces;
        }
        return Lists.newArrayList((Iterable)Iterables.concat(DefaultDirectSuperclassesInspector.classList(superclass), interfaces));
    }

    public static List<Class<?>> primitiveSuperclasses(Class<?> c) {
        return PRIMITIVE_SUPERCLASSES.get(c);
    }

    public static List<Class<?>> arrayDirectSuperclasses(int level, Class<?> c, DirectSuperclassesInspector parentTypeReader) {
        List<Class<?>> componentSuperclasses;
        List<Class<?>> classes = c.isArray() ? DefaultDirectSuperclassesInspector.arrayDirectSuperclasses(level + 1, c.getComponentType(), parentTypeReader) : ((componentSuperclasses = parentTypeReader.directParentClasses(c)).isEmpty() && !c.isInterface() ? (level == 1 ? new LinkedList(ARRAY_SUPERCLASSES) : DefaultDirectSuperclassesInspector.makeArrayClasses(ARRAY_SUPERCLASSES, level - 1)) : DefaultDirectSuperclassesInspector.makeArrayClasses(componentSuperclasses, level));
        return classes;
    }

    public static List<Class<?>> makeArrayClasses(List<Class<?>> classes, int dims) {
        Iterator<Class<?>> i = classes.iterator();
        LinkedList arrayClasses = new LinkedList();
        while (i.hasNext()) {
            arrayClasses.add(DefaultDirectSuperclassesInspector.makeArrayClass(i.next(), dims));
        }
        return arrayClasses;
    }

    public static Class<?> makeArrayClass(Class<?> c, int dims) {
        return Array.newInstance(c, new int[dims]).getClass();
    }

    static {
        HashMap<Class<Object>, List<Object>> superclasses = new HashMap<Class<Object>, List<Object>>();
        List none = Collections.emptyList();
        superclasses.put(Void.TYPE, none);
        superclasses.put(Boolean.TYPE, none);
        superclasses.put(Double.TYPE, DefaultDirectSuperclassesInspector.classList(Float.TYPE));
        superclasses.put(Float.TYPE, DefaultDirectSuperclassesInspector.classList(Long.TYPE));
        superclasses.put(Long.TYPE, DefaultDirectSuperclassesInspector.classList(Integer.TYPE));
        superclasses.put(Integer.TYPE, DefaultDirectSuperclassesInspector.classList(Short.TYPE, Character.TYPE));
        superclasses.put(Short.TYPE, DefaultDirectSuperclassesInspector.classList(Byte.TYPE));
        superclasses.put(Byte.TYPE, none);
        superclasses.put(Character.TYPE, none);
        PRIMITIVE_SUPERCLASSES = Collections.unmodifiableMap(superclasses);
        INSTANCE = new DefaultDirectSuperclassesInspector();
        ARRAY_SUPERCLASSES = DefaultDirectSuperclassesInspector.classList(Serializable.class, Cloneable.class, Object.class);
    }
}

