/*
 * Decompiled with CFR 0.152.
 */
package com.github.ruediste.c3java.method;

import com.github.ruediste.c3java.linearization.JavaC3;
import com.google.common.collect.Iterables;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Objects;

public class MethodUtil {
    public static Iterable<Method> getDeclarations(Method method) {
        ArrayList<Method> result = new ArrayList<Method>();
        result.add(method);
        for (Class cls : Iterables.skip(JavaC3.allSuperclasses(method.getDeclaringClass()), (int)1)) {
            for (Method m : cls.getDeclaredMethods()) {
                if (!m.getName().equals(method.getName()) || !Arrays.equals(m.getParameterTypes(), method.getParameterTypes()) || !MethodUtil.doesOverride(method, m)) continue;
                result.add(m);
            }
        }
        return result;
    }

    private static boolean doesOverride(Method m, Method ancestorMethod) {
        String mPackage;
        if (Modifier.isFinal(ancestorMethod.getModifiers())) {
            return false;
        }
        if (Modifier.isPublic(ancestorMethod.getModifiers())) {
            return true;
        }
        if (Modifier.isProtected(ancestorMethod.getModifiers())) {
            return true;
        }
        if (Modifier.isPrivate(ancestorMethod.getModifiers())) {
            return false;
        }
        String ancestorPackage = ancestorMethod.getDeclaringClass().getPackage().getName();
        return Objects.equals(ancestorPackage, mPackage = m.getDeclaringClass().getPackage().getName());
    }
}

