/*
 * Decompiled with CFR 0.152.
 */
package com.github.ruediste.c3java.properties;

import com.github.ruediste.c3java.invocationRecording.MethodInvocation;
import com.github.ruediste.c3java.invocationRecording.MethodInvocationUtil;
import com.github.ruediste.c3java.properties.PropertyInfo;
import java.util.ArrayList;
import java.util.List;

public class PropertyPath {
    public final List<PropertyPathNode> nodes = new ArrayList<PropertyPathNode>();

    public PropertyPathNode getLastNode() {
        if (this.nodes.size() == 0) {
            throw new RuntimeException("Path is empty");
        }
        return this.nodes.get(this.nodes.size() - 1);
    }

    public PropertyInfo getAccessedProperty() {
        PropertyPathNode lastNode = this.getLastNode();
        if (!(lastNode instanceof PropertyNode)) {
            throw new RuntimeException("Path does not end with a property but with a " + lastNode);
        }
        return ((PropertyNode)lastNode).property;
    }

    public Object evaluate(Object target) {
        Object result = target;
        for (PropertyPathNode node : this.nodes) {
            result = node.evaluate(result);
        }
        return result;
    }

    public void set(Object target, Object value) {
        Object current = target;
        for (int i = 0; i < this.nodes.size() - 1; ++i) {
            current = this.nodes.get(i).evaluate(current);
        }
        this.getAccessedProperty().setValue(current, value);
    }

    public static class MethodNode
    implements PropertyPathNode {
        public MethodInvocation<Object> invocation;

        MethodNode(MethodInvocation<Object> invocation) {
            this.invocation = invocation;
        }

        @Override
        public Object evaluate(Object target) {
            return MethodInvocationUtil.invoke(target, this.invocation);
        }

        public String toString() {
            return "MethodNode[" + this.invocation + "]";
        }
    }

    public static class PropertyNode
    implements PropertyPathNode {
        public final PropertyInfo property;

        public PropertyNode(PropertyInfo property) {
            this.property = property;
        }

        @Override
        public Object evaluate(Object target) {
            return this.property.getValue(target);
        }

        public String toString() {
            return "PropertyNode[" + this.property.getName() + "]";
        }
    }

    public static interface PropertyPathNode {
        public Object evaluate(Object var1);
    }
}

