/*
 * Decompiled with CFR 0.152.
 */
package com.github.ruediste1.lambdaPegParser;

import com.github.ruediste1.lambdaPegParser.LineInfo;
import com.github.ruediste1.lambdaPegParser.NoMatchException;
import com.github.ruediste1.lambdaPegParser.ParsingContext;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Objects;
import java.util.Optional;
import java.util.PrimitiveIterator;
import java.util.function.Predicate;
import java.util.function.Supplier;

public class Parser<TCtx extends ParsingContext<?>> {
    private final TCtx ctx;
    protected HashMap<RuleInvocation, RuleInvocation> currentMethods = new HashMap();

    public Parser(TCtx ctx) {
        this.ctx = ctx;
    }

    public final void EOI() {
        if (((ParsingContext)this.ctx).hasNext()) {
            throw new NoMatchException((ParsingContext<?>)this.ctx, ((ParsingContext)this.ctx).getIndex(), "End Of Input");
        }
    }

    public void Test(Runnable runnable) {
        ParsingContext.StateSnapshot snapshot = ((ParsingContext)this.ctx).snapshot();
        try {
            runnable.run();
        }
        finally {
            snapshot.restore();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T Test(Supplier<T> term) {
        ParsingContext.StateSnapshot snapshot = ((ParsingContext)this.ctx).snapshot();
        try {
            T t = term.get();
            return t;
        }
        finally {
            snapshot.restore();
        }
    }

    @SafeVarargs
    public final void FirstOf(Runnable ... choices) {
        for (Runnable choice : choices) {
            if (choice == null) continue;
            ParsingContext.StateSnapshot snapshot = ((ParsingContext)this.ctx).snapshot();
            try {
                choice.run();
                return;
            }
            catch (NoMatchException e) {
                snapshot.restore();
            }
        }
        throw new NoMatchException();
    }

    @SafeVarargs
    public final <T> T FirstOf(Supplier<? extends T> ... choices) {
        for (Supplier<T> supplier : choices) {
            if (supplier == null) continue;
            ParsingContext.StateSnapshot snapshot = ((ParsingContext)this.ctx).snapshot();
            try {
                return supplier.get();
            }
            catch (NoMatchException e) {
                snapshot.restore();
            }
        }
        throw new NoMatchException();
    }

    public final <T> T FirstOf(Iterable<Supplier<? extends T>> choices) {
        for (Supplier<T> choice : choices) {
            if (choice == null) continue;
            ParsingContext.StateSnapshot snapshot = ((ParsingContext)this.ctx).snapshot();
            try {
                return choice.get();
            }
            catch (NoMatchException e) {
                snapshot.restore();
            }
        }
        throw new NoMatchException();
    }

    public final void ZeroOrMore(Runnable term) {
        while (true) {
            ParsingContext.StateSnapshot snapshot = ((ParsingContext)this.ctx).snapshot();
            try {
                term.run();
            }
            catch (NoMatchException e) {
                snapshot.restore();
                return;
            }
        }
    }

    public final <T> Collection<T> ZeroOrMore(Supplier<T> term) {
        ArrayList<T> parts = new ArrayList<T>();
        while (true) {
            ParsingContext.StateSnapshot snapshot = ((ParsingContext)this.ctx).snapshot();
            try {
                parts.add(term.get());
            }
            catch (NoMatchException e) {
                snapshot.restore();
                return parts;
            }
        }
    }

    public final void Optional(Runnable term) {
        this.Optional(() -> {
            term.run();
            return null;
        });
    }

    public final <T> Optional<T> Optional(Supplier<T> term) {
        ParsingContext.StateSnapshot snapshot = ((ParsingContext)this.ctx).snapshot();
        try {
            return Optional.ofNullable(term.get());
        }
        catch (NoMatchException e) {
            snapshot.restore();
            return Optional.empty();
        }
    }

    public final String OneOrMoreChars(Predicate<Integer> criteria, String expectation) {
        String result = this.ZeroOrMoreChars(criteria, expectation);
        if (result.isEmpty()) {
            throw new NoMatchException();
        }
        return result;
    }

    public final String ZeroOrMoreChars(Predicate<Integer> criteria, String expectation) {
        StringBuilder sb = new StringBuilder();
        while (((ParsingContext)this.ctx).hasNext() && criteria.test(((ParsingContext)this.ctx).peek())) {
            sb.appendCodePoint(((ParsingContext)this.ctx).next());
        }
        ((ParsingContext)this.ctx).registerExpectation(expectation);
        return sb.toString();
    }

    public final <T> Collection<T> OneOrMore(Supplier<T> term) {
        ArrayList<T> parts = new ArrayList<T>();
        while (true) {
            ParsingContext.StateSnapshot snapshot = ((ParsingContext)this.ctx).snapshot();
            try {
                parts.add(term.get());
            }
            catch (NoMatchException e) {
                snapshot.restore();
                if (parts.isEmpty()) {
                    throw new NoMatchException();
                }
                return parts;
            }
        }
    }

    public final void OneOrMore(Runnable term) {
        boolean found = false;
        while (true) {
            ParsingContext.StateSnapshot snapshot = ((ParsingContext)this.ctx).snapshot();
            try {
                term.run();
                found = true;
            }
            catch (NoMatchException e) {
                snapshot.restore();
                if (!found) {
                    throw new NoMatchException();
                }
                return;
            }
        }
    }

    public final <T> T Atomic(String expectation, Supplier<T> term) {
        int startIdx = ((ParsingContext)this.ctx).getIndex();
        ParsingContext.ExpectationFrame oldFrame = ((ParsingContext)this.ctx).getExpectationFrame();
        ((ParsingContext)this.ctx).setNewExpectationFrame();
        try {
            T t = term.get();
            return t;
        }
        catch (NoMatchException e) {
            oldFrame.registerExpectation(startIdx, expectation);
            throw e;
        }
        finally {
            ((ParsingContext)this.ctx).setExpectationFrame(oldFrame);
        }
    }

    public final <T> T Expect(String expectation, Supplier<T> term) {
        ParsingContext.ExpectationFrame oldFrame = ((ParsingContext)this.ctx).getExpectationFrame();
        ParsingContext.ExpectationFrame newFrame = ((ParsingContext)this.ctx).setNewExpectationFrame();
        try {
            T t = term.get();
            return t;
        }
        catch (NoMatchException e) {
            oldFrame.registerExpectation(newFrame.index, expectation);
            throw e;
        }
        finally {
            ((ParsingContext)this.ctx).setExpectationFrame(oldFrame);
        }
    }

    public final String AnyChar() {
        if (!((ParsingContext)this.ctx).hasNext()) {
            throw new NoMatchException((ParsingContext<?>)this.ctx, "any character");
        }
        return new String(Character.toChars(((ParsingContext)this.ctx).next()));
    }

    private boolean matchString(String expected) {
        PrimitiveIterator.OfInt it = expected.codePoints().iterator();
        while (it.hasNext() && ((ParsingContext)this.ctx).hasNext()) {
            if (it.nextInt() != ((ParsingContext)this.ctx).peek()) {
                return false;
            }
            ((ParsingContext)this.ctx).next();
        }
        return !it.hasNext();
    }

    public final String String(String expected) {
        int startIndex = ((ParsingContext)this.ctx).getIndex();
        if (!this.matchString(expected)) {
            throw new NoMatchException((ParsingContext<?>)this.ctx, startIndex, expected);
        }
        return expected;
    }

    public final <T> T String(String expected, T result) {
        int startIndex = ((ParsingContext)this.ctx).getIndex();
        if (!this.matchString(expected)) {
            throw new NoMatchException((ParsingContext<?>)this.ctx, startIndex, expected);
        }
        return result;
    }

    public final <T> T String(String expected, Supplier<T> result) {
        int startIndex = ((ParsingContext)this.ctx).getIndex();
        if (!this.matchString(expected)) {
            throw new NoMatchException((ParsingContext<?>)this.ctx, startIndex, expected);
        }
        return result.get();
    }

    public final String Char(Predicate<Integer> predicate, String expectation) {
        int cp;
        int startIndex = ((ParsingContext)this.ctx).getIndex();
        if (((ParsingContext)this.ctx).hasNext() && predicate.test(cp = ((ParsingContext)this.ctx).next())) {
            return new String(Character.toChars(cp));
        }
        throw new NoMatchException((ParsingContext<?>)this.ctx, startIndex, expectation);
    }

    public final String NoneOf(String chars) {
        int startIndex = ((ParsingContext)this.ctx).getIndex();
        if (((ParsingContext)this.ctx).hasNext()) {
            int cp = ((ParsingContext)this.ctx).next();
            if (chars.codePoints().allMatch(x -> x != cp)) {
                return String.valueOf(Character.toChars(cp));
            }
        }
        throw new NoMatchException((ParsingContext<?>)this.ctx, startIndex, "any char except " + chars);
    }

    public final String CharRange(int first, int last) {
        int cp;
        int startIndex = ((ParsingContext)this.ctx).getIndex();
        if (((ParsingContext)this.ctx).hasNext() && (cp = ((ParsingContext)this.ctx).next()) >= first && cp <= last) {
            return new String(Character.toChars(cp));
        }
        StringBuilder sb = new StringBuilder();
        sb.append("character between ");
        sb.appendCodePoint(first);
        sb.append(" and ");
        sb.appendCodePoint(last);
        throw new NoMatchException((ParsingContext<?>)this.ctx, startIndex, sb.toString());
    }

    public TCtx getParsingContext() {
        return this.ctx;
    }

    public String toString() {
        LineInfo info = ((ParsingContext)this.ctx).currentPositionInfo();
        return this.getClass().getSimpleName() + " line: " + info.getLineNr() + "\n" + info.getLine() + "\n" + info.getUnderline(32, 94);
    }

    protected static class RuleInvocation {
        public int method;
        public Object[] args;
        public int position;
        public boolean recursive;
        public Seed seed;

        public String toString() {
            return "RuleInvocation [method=" + this.method + ", args=" + Arrays.toString(this.args) + ", position=" + this.position + ", recursive=" + this.recursive + ", seed=" + this.seed + "]";
        }

        public int hashCode() {
            return Objects.hash(this.method, Arrays.hashCode(this.args), this.position);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            RuleInvocation other = (RuleInvocation)obj;
            return this.method == other.method && Arrays.equals(this.args, other.args) && this.position == other.position;
        }

        public RuleInvocation(int method, Object[] args, int position) {
            this.method = method;
            this.args = args;
            this.position = position;
        }
    }

    protected static class Seed {
        public Object value;
        public ParsingContext.StateSnapshot snapshot;

        public Seed(Object value, ParsingContext.StateSnapshot snapshot) {
            this.value = value;
            this.snapshot = snapshot;
        }
    }
}

