/*
 * Decompiled with CFR 0.152.
 */
package com.github.ruediste1.lambdaPegParser;

import com.github.ruediste1.lambdaPegParser.Parser;
import com.github.ruediste1.lambdaPegParser.ParsingContext;
import com.github.ruediste1.lambdaPegParser.PrototypeParser;
import com.github.ruediste1.lambdaPegParser.weaving.LocalVariableShifter;
import com.github.ruediste1.lambdaPegParser.weaving.MethodCallInliner;
import com.github.ruediste1.lambdaPegParser.weaving.MinMaxLineMethodAdapter;
import com.github.ruediste1.lambdaPegParser.weaving.PrototypeCustomizer;
import com.google.common.io.ByteStreams;
import com.google.common.reflect.TypeToken;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import net.sf.cglib.proxy.Callback;
import net.sf.cglib.proxy.Enhancer;
import net.sf.cglib.proxy.MethodInterceptor;
import net.sf.cglib.proxy.MethodProxy;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;
import org.objectweb.asm.commons.Remapper;
import org.objectweb.asm.commons.RemappingMethodAdapter;
import org.objectweb.asm.commons.SimpleRemapper;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.util.CheckClassAdapter;

public class ParserFactory {
    public static <T> T create(Class<? extends T> parserClass, Class<T> intrface, String input) {
        return ParserFactory.create(parserClass, intrface, ParserFactory.createParsingContext(parserClass, input));
    }

    public static <T> T create(Class<? extends T> cls, Class<T> intrface, ParsingContext<?> ctx) {
        return (T)ParserFactory.instantiateWeavedParser(ctx, cls.getName());
    }

    public static <T extends Parser<?>> T create(Class<T> cls, String input) {
        ParsingContext<?> ctx = ParserFactory.createParsingContext(cls, input);
        return ParserFactory.create(cls, ctx);
    }

    public static ParsingContext<?> createParsingContext(Class<?> parserClass, String input) {
        ParsingContext ctx;
        try {
            ctx = (ParsingContext)ParserFactory.getParsingContextType(parserClass).getConstructor(String.class).newInstance(input);
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            throw new RuntimeException("Error while instantiating parsing context", e);
        }
        return ctx;
    }

    public static <T extends Parser<?>> T create(Class<T> cls, ParsingContext<?> ctx) {
        String parserClassNasme = cls.getName();
        final Object weavedParser = ParserFactory.instantiateWeavedParser(ctx, parserClassNasme);
        Enhancer e = new Enhancer();
        e.setSuperclass(cls);
        e.setCallback((Callback)new MethodInterceptor(){

            public Object intercept(Object obj, Method method, Object[] args, MethodProxy proxy) throws Throwable {
                Method m = this.findMethod(weavedParser.getClass().getMethods(), method.getName(), method.getParameterTypes());
                if (m == null) {
                    m = this.findMethod(weavedParser.getClass(), method.getName(), method.getParameterTypes());
                }
                m.setAccessible(true);
                try {
                    return m.invoke(weavedParser, args);
                }
                catch (InvocationTargetException e) {
                    throw e.getCause();
                }
            }

            private Method findMethod(Class<?> cls, String methodName, Class<?>[] parameterTypes) throws NoSuchMethodException, SecurityException {
                if (cls == null) {
                    return null;
                }
                Method m = this.findMethod(cls.getDeclaredMethods(), methodName, parameterTypes);
                return m == null ? this.findMethod(cls.getSuperclass(), methodName, parameterTypes) : m;
            }

            private Method findMethod(Method[] candidates, String methodName, Class<?>[] parameterTypes) {
                for (Method m : candidates) {
                    if (!methodName.equals(m.getName()) || !Arrays.equals(parameterTypes, m.getParameterTypes())) continue;
                    return m;
                }
                return null;
            }
        });
        return (T)((Parser)e.create(new Class[]{ParserFactory.getParsingContextType(cls)}, new Object[]{ctx}));
    }

    private static Object instantiateWeavedParser(ParsingContext<?> ctx, String parserClassNasme) {
        try {
            Class<?> weavedClass = new WeavedClassLoader(ParserFactory.class.getClassLoader(), parserClassNasme, ParserFactory.weaveClass(parserClassNasme)).loadClass(parserClassNasme);
            Constructor<?> constructor = weavedClass.getConstructor(ParserFactory.getParsingContextType(weavedClass));
            constructor.setAccessible(true);
            Object weavedParser = constructor.newInstance(ctx);
            return weavedParser;
        }
        catch (ClassNotFoundException | IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            throw new RuntimeException("Error while weaving and instantiating parser class", e);
        }
    }

    private static Class<?> getParsingContextType(Class<?> parserClass) {
        return TypeToken.of(parserClass).resolveType(Parser.class.getTypeParameters()[0]).getRawType();
    }

    private static byte[] weaveClass(String parserClassName) {
        ClassReader classReader;
        InputStream in = ParserFactory.class.getClassLoader().getResourceAsStream(parserClassName.replace('.', '/') + ".class");
        try {
            classReader = new ClassReader(in);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        ClassNode cn = new ClassNode();
        classReader.accept((ClassVisitor)cn, 8);
        MethodNode prototype = ParserFactory.loadPrototypeMethodNode();
        for (int i = 0; i < cn.methods.size(); ++i) {
            MethodNode ruleNode = (MethodNode)cn.methods.get(i);
            if ("<init>".equals(ruleNode.name) || (8 & ruleNode.access) != 0 || (0x1000 & ruleNode.access) != 0) continue;
            MinMaxLineMethodAdapter minMaxLineMethodAdapter = new MinMaxLineMethodAdapter(327680, null);
            ruleNode.accept((MethodVisitor)minMaxLineMethodAdapter);
            String[] exceptions = ruleNode.exceptions.toArray(new String[0]);
            MethodNode newNode = new MethodNode(ruleNode.access, ruleNode.name, ruleNode.desc, ruleNode.signature, exceptions);
            RemappingMethodAdapter remapper = new RemappingMethodAdapter(ruleNode.access, ruleNode.desc, (MethodVisitor)newNode, (Remapper)new SimpleRemapper(PrototypeParser.class.getName().replace('.', '/'), parserClassName.replace('.', '/')));
            MethodCallInliner inliner = new MethodCallInliner((MethodVisitor)remapper, ruleNode, minMaxLineMethodAdapter);
            PrototypeCustomizer prototypeCustomizer = new PrototypeCustomizer((MethodVisitor)inliner, ruleNode, i);
            LocalVariableShifter shifter = new LocalVariableShifter(Type.getArgumentTypes((String)ruleNode.desc).length, prototype.access, prototype.desc, (MethodVisitor)prototypeCustomizer);
            prototype.instructions.resetLabels();
            prototype.accept((MethodVisitor)shifter);
            cn.methods.set(i, newNode);
        }
        ClassWriter cw = new ClassWriter(3);
        cn.accept((ClassVisitor)cw);
        byte[] b = cw.toByteArray();
        PrintWriter pw = new PrintWriter(System.out);
        CheckClassAdapter.verify((ClassReader)new ClassReader(b), (boolean)false, (PrintWriter)pw);
        return b;
    }

    private static MethodNode loadPrototypeMethodNode() {
        ClassReader classReader;
        InputStream in = ParserFactory.class.getClassLoader().getResourceAsStream(PrototypeParser.class.getName().replace('.', '/') + ".class");
        try {
            classReader = new ClassReader(in);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        ClassNode classNode = new ClassNode();
        classReader.accept((ClassVisitor)classNode, 8);
        for (MethodNode node : classNode.methods) {
            if (!"prototypeAdvice".equals(node.name)) continue;
            return node;
        }
        throw new RuntimeException("Prototype method not found");
    }

    public static class WeavedClassLoader
    extends ClassLoader {
        private String parserClassName;
        private byte[] weavedByteCode;

        public WeavedClassLoader(ClassLoader parent, String parserClassName, byte[] weavedByteCode) {
            super(parent);
            this.parserClassName = parserClassName;
            this.weavedByteCode = weavedByteCode;
        }

        @Override
        public Class<?> loadClass(String name) throws ClassNotFoundException {
            if (name.equals(this.parserClassName)) {
                this.defineClass(this.parserClassName, this.weavedByteCode, 0, this.weavedByteCode.length);
            }
            if (name.startsWith(this.parserClassName) && name.substring(this.parserClassName.length()).startsWith("$")) {
                byte[] bb;
                InputStream in = this.getParent().getResourceAsStream(name.replace('.', '/') + ".class");
                try {
                    bb = ByteStreams.toByteArray((InputStream)in);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
                return this.defineClass(name, bb, 0, bb.length);
            }
            return super.loadClass(name);
        }
    }
}

