/*
 * Decompiled with CFR 0.152.
 */
package com.github.ruediste1.lambdaPegParser;

import com.github.ruediste1.lambdaPegParser.LambdaPegEvent;
import com.github.ruediste1.lambdaPegParser.LineInfo;
import com.github.ruediste1.lambdaPegParser.NoMatchException;
import com.github.ruediste1.lambdaPegParser.ParsingState;
import com.github.ruediste1.lambdaPegParser.RuleLoggingInfo;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.stream.Collectors;

public class ParsingContext<TState extends ParsingState<TState>> {
    private String content;
    private TState state;
    public final LambdaPegEvent<String> contentSetEvent = new LambdaPegEvent();
    private ExpectationFrame expectationFrame;
    public final LambdaPegEvent<Expectation> expectationRegistered = new LambdaPegEvent();
    public final LambdaPegEvent<RuleLoggingInfo> recursiveEvent = new LambdaPegEvent();
    public final LambdaPegEvent<RuleLoggingInfo> enteringEvent = new LambdaPegEvent();
    public final LambdaPegEvent<RuleLoggingInfo> failedEvent = new LambdaPegEvent();
    public final LambdaPegEvent<RuleLoggingInfo> leavingEvent = new LambdaPegEvent();
    public final LambdaPegEvent<RuleLoggingInfo> retryingEvent = new LambdaPegEvent();

    public ParsingContext(String content) {
        this.setContent(content);
    }

    public String getContent() {
        return this.content;
    }

    public final void setContent(String content) {
        this.content = content;
        this.state = this.createInitialState();
        this.expectationFrame = new ExpectationFrame();
        this.contentSetEvent.fire(content);
    }

    protected TState createInitialState() {
        return (TState)new ParsingState();
    }

    public int peek() {
        if (!this.hasNext()) {
            throw new NoMatchException();
        }
        return this.content.codePointAt(this.getIndex());
    }

    public int next() {
        if (!this.hasNext()) {
            throw new NoMatchException();
        }
        int result = this.content.codePointAt(this.getIndex());
        ((ParsingState)this.state).setIndex(this.getIndex() + Character.charCount(result));
        return result;
    }

    public boolean hasNext() {
        return this.getIndex() < this.content.length();
    }

    public int getIndex() {
        return ((ParsingState)this.state).getIndex();
    }

    public StateSnapshot snapshot() {
        return new StateSnapshotImpl();
    }

    public void registerExpectation(String expectation) {
        this.registerExpectation(this.getIndex(), expectation);
    }

    public void registerExpectation(int index, String expectation) {
        this.expectationFrame.registerExpectation(index, expectation);
        this.expectationRegistered.fire(new Expectation(index, expectation));
    }

    public ErrorDesciption getErrorDescription() {
        ErrorDesciption result = new ErrorDesciption(Collections.unmodifiableSet(this.expectationFrame.expectations), this.content, this.expectationFrame.index);
        return result;
    }

    public ExpectationFrame getExpectationFrame() {
        return this.expectationFrame;
    }

    public void setExpectationFrame(ExpectationFrame expectationFrame) {
        this.expectationFrame = expectationFrame;
    }

    public ExpectationFrame setNewExpectationFrame() {
        this.expectationFrame = new ExpectationFrame();
        return this.expectationFrame;
    }

    public void recursive(RuleLoggingInfo loggingInfo) {
        loggingInfo.index = this.getIndex();
        this.recursiveEvent.fire(loggingInfo);
    }

    public void entering(RuleLoggingInfo loggingInfo) {
        loggingInfo.index = this.getIndex();
        this.enteringEvent.fire(loggingInfo);
    }

    public void failed(RuleLoggingInfo loggingInfo) {
        loggingInfo.index = this.getIndex();
        this.failedEvent.fire(loggingInfo);
    }

    public void leaving(RuleLoggingInfo loggingInfo) {
        loggingInfo.index = this.getIndex();
        this.leavingEvent.fire(loggingInfo);
    }

    public void retrying(RuleLoggingInfo loggingInfo) {
        loggingInfo.index = this.getIndex();
        this.retryingEvent.fire(loggingInfo);
    }

    public String toString() {
        LineInfo info = this.currentPositionInfo();
        return this.getClass().getSimpleName() + "Line " + info.getLineNr() + "\n" + info.getLine() + "\n" + info.getUnderline(32, 42);
    }

    public LineInfo currentPositionInfo() {
        return new LineInfo(this.content, this.getIndex());
    }

    public static class ErrorDesciption {
        public int errorPosition;
        public Set<String> expectations;
        public LineInfo errorLineInfo;

        public ErrorDesciption(Set<String> expectations, String content, int errorPosition) {
            this.expectations = expectations;
            this.errorPosition = errorPosition;
            this.errorLineInfo = new LineInfo(content, errorPosition);
        }

        public String toString() {
            return "Error on line " + this.errorLineInfo.getLineNr() + ". Expected: " + this.expectations.stream().collect(Collectors.joining(", ")) + "\n" + this.errorLineInfo.getLine() + "\n" + this.errorLineInfo.getUnderline(32, 94);
        }
    }

    public static class Expectation {
        public int index;
        public String expectation;

        public Expectation(int index, String expectation) {
            this.index = index;
            this.expectation = expectation;
        }
    }

    public static class ExpectationFrame {
        public int index;
        public Set<String> expectations = new LinkedHashSet<String>();

        public void registerExpectation(int index, String expectation) {
            if (this.index < index) {
                this.index = index;
                this.expectations.clear();
            }
            if (this.index == index) {
                this.expectations.add(expectation);
            }
        }

        public void merge(ExpectationFrame other) {
            if (this.index == other.index) {
                this.expectations.addAll(other.expectations);
            }
            if (this.index < other.index) {
                this.expectations = new HashSet<String>(other.expectations);
            }
        }
    }

    private class StateSnapshotImpl
    implements StateSnapshot {
        TState snapshot;

        public StateSnapshotImpl() {
            this.snapshot = ParsingContext.this.state.clone();
        }

        @Override
        public void restore() {
            this.checkSnapshot();
            ParsingContext.this.state = this.snapshot;
            this.snapshot = null;
        }

        @Override
        public void restoreClone() {
            this.checkSnapshot();
            ParsingContext.this.state = (ParsingState)((ParsingState)this.snapshot).clone();
        }

        private void checkSnapshot() {
            if (this.snapshot == null) {
                throw new RuntimeException("cannot restore after the first call to restore()");
            }
        }
    }

    public static interface StateSnapshot {
        public void restore();

        public void restoreClone();
    }
}

