/*
 * Decompiled with CFR 0.152.
 */
package com.github.ruediste1.lambdaPegParser;

import com.github.ruediste1.lambdaPegParser.LineInfo;
import com.github.ruediste1.lambdaPegParser.ParsingContext;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Writer;

public class Tracer {
    private PrintWriter target;
    private int depth;
    private int position = -1;
    private final ParsingContext<?> ctx;

    public Tracer(ParsingContext<?> ctx, Writer target) {
        this(ctx, new PrintWriter(target));
    }

    public Tracer(ParsingContext<?> ctx, PrintWriter target) {
        this.ctx = ctx;
        this.target = target;
        this.register(ctx);
    }

    public Tracer(ParsingContext<?> ctx, OutputStream out) {
        this(ctx, new PrintWriter(out));
    }

    private void indent() {
        this.indent(this.depth);
    }

    private void indent(int depth) {
        String indent = this.indentImpl(depth);
        if (this.position < this.ctx.getIndex() || this.position > this.ctx.getIndex() + 10) {
            LineInfo info = this.ctx.currentPositionInfo();
            this.target.append(indent + "index " + this.ctx.getIndex() + " Line " + info.getLineNr() + "\n" + indent + info.getLine() + "\n" + indent + info.getUnderline(32, 94) + "\n");
            this.position = this.ctx.getIndex();
        }
        this.target.append(indent);
    }

    private String indentImpl(int depth) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < depth; ++i) {
            sb.append("  ");
        }
        return sb.toString();
    }

    private void register(ParsingContext<?> ctx) {
        ctx.contentSetEvent.register((T content) -> {
            this.depth = 0;
        });
        ctx.enteringEvent.register((T info) -> {
            this.indent();
            this.target.println(info.parserClass.getName() + "." + info.methodName + " Entering, index: " + info.index);
            ++this.depth;
            this.target.flush();
        });
        ctx.failedEvent.register((T info) -> {
            --this.depth;
            this.indent();
            this.target.println(info.parserClass.getName() + "." + info.methodName + " Failed, index: " + info.index);
            this.target.flush();
        });
        ctx.leavingEvent.register((T info) -> {
            --this.depth;
            this.indent();
            this.target.println(info.parserClass.getName() + "." + info.methodName + " Leaving, index: " + info.index);
            this.target.flush();
        });
        ctx.recursiveEvent.register((T info) -> {
            this.indent(this.depth + 1);
            this.target.println(info.parserClass.getName() + "." + info.methodName + " recursive, advancing to: " + info.index);
            this.target.flush();
        });
        ctx.retryingEvent.register((T info) -> {
            this.indent(this.depth - 1);
            this.target.println(info.parserClass.getName() + "." + info.methodName + " Retrying, was at index: " + info.index);
            this.target.flush();
        });
        ctx.expectationRegistered.register((T e) -> {
            this.indent();
            this.target.println("index " + e.index + " unmet expectation: " + e.expectation);
            this.target.flush();
        });
    }
}

