/**
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package scalapi.embedmongo

import de.flapdoodle.embed.mongo.config.MongodConfig
import de.flapdoodle.embed.mongo.distribution.Version
import de.flapdoodle.embed.mongo.MongodStarter._
import de.flapdoodle.embed.process.runtime.Network.localhostIsIPv6
import com.mongodb.MongoClient
import EmbedMongoSupport.defaultPort

trait EmbedMongoSupport {

  private val mongoConfig = new MongodConfig(Version.Main.PRODUCTION, defaultPort, localhostIsIPv6)
  private val mongoDaemon = getDefaultInstance.prepare(mongoConfig).start()
  protected val mongo = new MongoClient

  protected def stopMongo() {
    mongoDaemon.stop()
  }

}

object EmbedMongoSupport {

  val defaultPort = 27017

}
