/*
 * Decompiled with CFR 0.152.
 */
package com.github.scribejava.httpclient.ahc;

import com.github.scribejava.core.httpclient.HttpClient;
import com.github.scribejava.core.model.OAuthAsyncRequestCallback;
import com.github.scribejava.core.model.OAuthRequestAsync;
import com.github.scribejava.core.model.Verb;
import com.github.scribejava.httpclient.ahc.AhcHttpClientConfig;
import com.github.scribejava.httpclient.ahc.OAuthAsyncCompletionHandler;
import java.io.File;
import java.io.IOException;
import java.util.Map;
import java.util.concurrent.Future;
import org.asynchttpclient.AsyncHttpClient;
import org.asynchttpclient.AsyncHttpClientConfig;
import org.asynchttpclient.BoundRequestBuilder;
import org.asynchttpclient.DefaultAsyncHttpClient;

public class AhcHttpClient
implements HttpClient {
    private final AsyncHttpClient client;

    public AhcHttpClient(AhcHttpClientConfig ahcConfig) {
        AsyncHttpClientConfig clientConfig = ahcConfig.getClientConfig();
        this.client = clientConfig == null ? new DefaultAsyncHttpClient() : new DefaultAsyncHttpClient(clientConfig);
    }

    public AhcHttpClient(AsyncHttpClient ahcClient) {
        this.client = ahcClient;
    }

    public void close() throws IOException {
        this.client.close();
    }

    public <T> Future<T> executeAsync(String userAgent, Map<String, String> headers, Verb httpVerb, String completeUrl, byte[] bodyContents, OAuthAsyncRequestCallback<T> callback, OAuthRequestAsync.ResponseConverter<T> converter) {
        return this.doExecuteAsync(userAgent, headers, httpVerb, completeUrl, BodySetter.BYTE_ARRAY, bodyContents, callback, converter);
    }

    public <T> Future<T> executeAsync(String userAgent, Map<String, String> headers, Verb httpVerb, String completeUrl, String bodyContents, OAuthAsyncRequestCallback<T> callback, OAuthRequestAsync.ResponseConverter<T> converter) {
        return this.doExecuteAsync(userAgent, headers, httpVerb, completeUrl, BodySetter.STRING, bodyContents, callback, converter);
    }

    public <T> Future<T> executeAsync(String userAgent, Map<String, String> headers, Verb httpVerb, String completeUrl, File bodyContents, OAuthAsyncRequestCallback<T> callback, OAuthRequestAsync.ResponseConverter<T> converter) {
        return this.doExecuteAsync(userAgent, headers, httpVerb, completeUrl, BodySetter.FILE, bodyContents, callback, converter);
    }

    private <T> Future<T> doExecuteAsync(String userAgent, Map<String, String> headers, Verb httpVerb, String completeUrl, BodySetter bodySetter, Object bodyContents, OAuthAsyncRequestCallback<T> callback, OAuthRequestAsync.ResponseConverter<T> converter) {
        BoundRequestBuilder boundRequestBuilder;
        switch (httpVerb) {
            case GET: {
                boundRequestBuilder = this.client.prepareGet(completeUrl);
                break;
            }
            case POST: {
                boundRequestBuilder = this.client.preparePost(completeUrl);
                break;
            }
            case PUT: {
                boundRequestBuilder = this.client.preparePut(completeUrl);
                break;
            }
            case DELETE: {
                boundRequestBuilder = this.client.prepareDelete(completeUrl);
                break;
            }
            default: {
                throw new IllegalArgumentException("message build error: unknown verb type");
            }
        }
        if (httpVerb == Verb.POST || httpVerb == Verb.PUT || httpVerb == Verb.DELETE) {
            if (!headers.containsKey("Content-Type")) {
                boundRequestBuilder = (BoundRequestBuilder)boundRequestBuilder.addHeader((CharSequence)"Content-Type", "application/x-www-form-urlencoded");
            }
            boundRequestBuilder = bodySetter.setBody(boundRequestBuilder, bodyContents);
        }
        for (Map.Entry<String, String> header : headers.entrySet()) {
            boundRequestBuilder.addHeader((CharSequence)header.getKey(), header.getValue());
        }
        if (userAgent != null) {
            boundRequestBuilder.setHeader((CharSequence)"User-Agent", userAgent);
        }
        return boundRequestBuilder.execute(new OAuthAsyncCompletionHandler<T>(callback, converter));
    }

    private static enum BodySetter {
        BYTE_ARRAY{

            @Override
            BoundRequestBuilder setBody(BoundRequestBuilder requestBuilder, Object bodyContents) {
                return (BoundRequestBuilder)requestBuilder.setBody((byte[])bodyContents);
            }
        }
        ,
        STRING{

            @Override
            BoundRequestBuilder setBody(BoundRequestBuilder requestBuilder, Object bodyContents) {
                return (BoundRequestBuilder)requestBuilder.setBody((String)bodyContents);
            }
        }
        ,
        FILE{

            @Override
            BoundRequestBuilder setBody(BoundRequestBuilder requestBuilder, Object bodyContents) {
                return (BoundRequestBuilder)requestBuilder.setBody((File)bodyContents);
            }
        };


        abstract BoundRequestBuilder setBody(BoundRequestBuilder var1, Object var2);
    }
}

