/*
 * Decompiled with CFR 0.152.
 */
package com.github.secondbase.example.main;

import com.github.secondbase.consul.ConsulModule;
import com.github.secondbase.consul.registration.ConsulRegistrationMetricsWebConsole;
import com.github.secondbase.core.SecondBase;
import com.github.secondbase.core.SecondBaseException;
import com.github.secondbase.core.config.SecondBaseModule;
import com.github.secondbase.flags.Flag;
import com.github.secondbase.flags.Flags;
import com.github.secondbase.logging.JsonLoggerModule;
import com.github.secondbase.webconsole.HttpWebConsole;
import com.github.secondbase.webconsole.PrometheusWebConsole;
import com.github.secondbase.webconsole.widget.Widget;
import com.sun.net.httpserver.HttpServer;
import io.prometheus.client.Counter;
import java.io.IOException;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HelloAll {
    @Flag(name="variable")
    private static String var = "default";
    @Flag(name="counter")
    private static int counter = 1;
    private static final Logger log = LoggerFactory.getLogger((String)HelloAll.class.getName());
    private static final Counter mycounter = (Counter)Counter.build((String)"mycounter", (String)"a counter").register();

    private HelloAll() {
    }

    public static void startHelloAllService() throws IOException {
        mycounter.inc((double)counter);
        log.info(var);
        HttpServer server = HttpServer.create(new InetSocketAddress(8000), 0);
        server.createContext("/healthcheck", httpExchange -> {
            byte[] response = "This is my service health check".getBytes();
            httpExchange.sendResponseHeaders(200, response.length);
            OutputStream os = httpExchange.getResponseBody();
            os.write(response);
            os.close();
        });
        server.createContext("/", httpExchange -> {
            byte[] response = "This is my service response".getBytes();
            httpExchange.sendResponseHeaders(200, response.length);
            OutputStream os = httpExchange.getResponseBody();
            os.write(response);
            os.close();
        });
        server.start();
    }

    public static void main(String[] args) throws SecondBaseException, IOException {
        String[] realArgs = new String[]{"--service-name=HelloAll", "--service-environment=testing", "--enable-consul", "--consul-host=localhost:8500", "--service-port=8000", "--consul-health-check-path=/healthcheck", "--consul-tags=tagone,tagtwo", "--datacenter=local", "--webconsole-port=8001", "--variable=Hello, World!", "--counter=42"};
        JsonLoggerModule jsonLogger = new JsonLoggerModule();
        PrometheusWebConsole prometheusWidget = new PrometheusWebConsole();
        Widget[] widgets = new Widget[]{prometheusWidget};
        HttpWebConsole webConsole = new HttpWebConsole(widgets);
        ConsulModule consul = new ConsulModule();
        ConsulRegistrationMetricsWebConsole registerMetrics = new ConsulRegistrationMetricsWebConsole(webConsole, consul);
        SecondBaseModule[] modules = new SecondBaseModule[]{jsonLogger, consul, prometheusWidget, webConsole, registerMetrics};
        Flags flags = new Flags().loadOpts(HelloAll.class);
        new SecondBase(realArgs, modules, flags);
        HelloAll.startHelloAllService();
    }
}

