/*
 * Decompiled with CFR 0.152.
 */
package com.github.secondbase.flags;

import com.github.secondbase.flags.Flag;
import com.github.secondbase.flags.NoOption;
import com.github.secondbase.secrets.SecretHandler;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.TreeMap;
import javax.annotation.PostConstruct;
import joptsimple.ArgumentAcceptingOptionSpec;
import joptsimple.OptionParser;
import joptsimple.OptionSet;
import joptsimple.OptionSpec;

public final class Flags {
    private final OptionParser optionParser = new OptionParser();
    private final OptionSpec<Void> help = this.optionParser.accepts("help", "Show this help");
    private final OptionSpec<Void> version = this.optionParser.accepts("version", "Show version");
    private final OptionSpec<String> propertiesFile = this.optionParser.accepts("properties-file", "Load properties from a given file").withRequiredArg().ofType(String.class).withValuesSeparatedBy(';');
    private String versionString = "NA";
    private final Map<String, OptionHolder> options = new HashMap<String, OptionHolder>();
    private OptionSet optionSet;
    private List<?> nonOptionArguments;
    private final Map<Class<? extends Enum<?>>, List<String>> enumOptions = new HashMap();
    private final List<Object> objects = new ArrayList<Object>();
    private final List<Class<?>> classes = new ArrayList();
    private SecretHandler[] secretHandlers;

    public Flags() {
        this(new SecretHandler[0]);
    }

    public Flags(SecretHandler[] secretHandlers) {
        this.secretHandlers = secretHandlers;
    }

    public Flags loadOpts(Class<?> c) {
        this.classes.add(c);
        return this.loadOpts(c, false);
    }

    public Flags loadOpts(Object o) {
        this.objects.add(o);
        return this.loadOpts(o, true);
    }

    private Flags loadOpts(Object o, boolean instanced) {
        Field[] declaredFields;
        Class c = null;
        if (instanced) {
            declaredFields = o.getClass().getDeclaredFields();
        } else {
            c = (Class)o;
            declaredFields = c.getDeclaredFields();
        }
        block7: for (Field field : declaredFields) {
            Flag flag = field.getAnnotation(Flag.class);
            if (null == flag) continue;
            if (!instanced && !Modifier.isStatic(field.getModifiers())) {
                throw new IllegalArgumentException("Field " + field.toGenericString() + " is not static. Flag fields must be static when initializing through a Class instance.");
            }
            String name = flag.name();
            String description = flag.description();
            FieldType type = Flags.fieldTypeOf(field, flag);
            switch (type) {
                case INTEGER: {
                    ArgumentAcceptingOptionSpec intOption = flag.required() ? this.optionParser.accepts(name, description).withRequiredArg().ofType(Integer.class) : this.optionParser.accepts(name, description).withOptionalArg().ofType(Integer.class);
                    if (instanced) {
                        this.addInstancedOption(type, flag, field, (OptionSpec<?>)intOption, o);
                        continue block7;
                    }
                    this.addOption(type, flag, field, (OptionSpec<?>)intOption, c);
                    continue block7;
                }
                case STRING: {
                    ArgumentAcceptingOptionSpec stringOption = flag.required() ? this.optionParser.accepts(name, description).withRequiredArg().ofType(String.class) : this.optionParser.accepts(name, description).withOptionalArg().ofType(String.class);
                    if (instanced) {
                        this.addInstancedOption(type, flag, field, (OptionSpec<?>)stringOption, o);
                        continue block7;
                    }
                    this.addOption(type, flag, field, (OptionSpec<?>)stringOption, c);
                    continue block7;
                }
                case BOOLEAN: {
                    ArgumentAcceptingOptionSpec booleanOption = flag.required() ? this.optionParser.accepts(name, description).withOptionalArg().ofType(Boolean.class) : this.optionParser.accepts(name, description).withOptionalArg().ofType(Boolean.class);
                    if (instanced) {
                        this.addInstancedOption(type, flag, field, (OptionSpec<?>)booleanOption, o);
                        continue block7;
                    }
                    this.addOption(type, flag, field, (OptionSpec<?>)booleanOption, c);
                    continue block7;
                }
                case LONG: {
                    ArgumentAcceptingOptionSpec longOption = flag.required() ? this.optionParser.accepts(name, description).withRequiredArg().ofType(Long.class) : this.optionParser.accepts(name, description).withOptionalArg().ofType(Long.class);
                    if (instanced) {
                        this.addInstancedOption(type, flag, field, (OptionSpec<?>)longOption, o);
                        continue block7;
                    }
                    this.addOption(type, flag, field, (OptionSpec<?>)longOption, c);
                    continue block7;
                }
                case ENUM: {
                    Class<Enum<?>> enumClass = flag.options();
                    Enum<?>[] enumConstants = enumClass.getEnumConstants();
                    if (enumConstants == null) {
                        throw new IllegalArgumentException("Field " + field.toGenericString() + " is not an enum type.");
                    }
                    for (Enum<?> object : enumConstants) {
                        this.addEnumOption(enumClass, object.toString());
                    }
                    ArgumentAcceptingOptionSpec enumOption = flag.required() ? this.optionParser.accepts(name, description).withRequiredArg().ofType(enumClass) : this.optionParser.accepts(name, description).withOptionalArg().ofType(enumClass);
                    if (instanced) {
                        this.addInstancedOption(type, flag, field, (OptionSpec<?>)enumOption, o);
                        continue block7;
                    }
                    this.addOption(type, flag, field, (OptionSpec<?>)enumOption, c);
                    continue block7;
                }
                default: {
                    throw new IllegalArgumentException("Field " + field.toGenericString() + " is not of a supported type.");
                }
            }
        }
        return this;
    }

    public Flags setVersionString(String versionString) {
        this.versionString = versionString;
        return this;
    }

    public List<?> getNonOptionArguments() {
        return this.nonOptionArguments;
    }

    private void addEnumOption(Class<? extends Enum<?>> enumClass, String validOption) {
        List<String> optionsForClass = this.enumOptions.get(enumClass);
        if (optionsForClass == null) {
            optionsForClass = new ArrayList<String>();
        }
        optionsForClass.add(validOption);
        this.enumOptions.put(enumClass, optionsForClass);
    }

    private void addOption(FieldType type, Flag flag, Field field, OptionSpec<?> option, Class<?> c) throws IllegalArgumentException {
        if (this.options.containsKey(flag.name())) {
            throw new IllegalArgumentException("Flag named " + flag.name() + " is defined more than once.");
        }
        this.options.put(flag.name(), new OptionHolder(type, flag, field, option, c));
    }

    private void addInstancedOption(FieldType type, Flag flag, Field field, OptionSpec<?> option, Object c) throws IllegalArgumentException {
        if (this.options.containsKey(flag.name())) {
            throw new IllegalArgumentException("Flag named " + flag.name() + " is defined more than once.");
        }
        this.options.put(flag.name(), new OptionHolder(type, flag, field, option, c));
    }

    public String[] fetchSecrets(String[] args) {
        String[] ret = args;
        for (SecretHandler secretHandler : this.secretHandlers) {
            ret = secretHandler.fetch(ret);
        }
        return ret;
    }

    public Flags parse(String[] args) {
        String[] allArgs;
        this.optionSet = this.optionParser.parse(args);
        this.nonOptionArguments = this.optionSet.nonOptionArguments();
        if (this.nonOptionArguments == null) {
            this.nonOptionArguments = new ArrayList();
        }
        if (this.helpFlagged()) {
            return this;
        }
        if (this.versionFlagged()) {
            return this;
        }
        if (this.propertiesFlagged()) {
            List files = this.optionSet.valuesOf(this.propertiesFile);
            ArrayList newArgs = new ArrayList();
            for (String filename : files) {
                Properties props = new Properties();
                try {
                    FileInputStream stream = new FileInputStream(filename);
                    props.load(stream);
                    Enumeration<?> keys = props.propertyNames();
                    while (keys.hasMoreElements()) {
                        String flagName = (String)keys.nextElement();
                        if (this.optionSet.hasArgument(flagName)) continue;
                        newArgs.add("--" + flagName);
                        String value = props.getProperty(flagName);
                        if (value == null || value.isEmpty()) continue;
                        newArgs.add(value);
                    }
                    stream.close();
                }
                catch (IOException e) {
                    throw new RuntimeException("Could not parse property-file", e);
                }
            }
            Collections.addAll(newArgs, args);
            allArgs = newArgs.toArray(new String[newArgs.size()]);
        } else {
            allArgs = args;
        }
        String[] allArgsWithSecrets = this.fetchSecrets(allArgs);
        this.optionSet = this.optionParser.parse(allArgsWithSecrets);
        for (OptionHolder holder : this.options.values()) {
            try {
                OptionSpec<?> optionSpec = holder.getOptionSpec();
                if (this.optionSet.has(optionSpec)) {
                    Object value = this.optionSet.valueOf(optionSpec);
                    switch (holder.getType()) {
                        case INTEGER: {
                            if (holder.isInstanced()) {
                                holder.getField().set(holder.getObjectSource(), value);
                                break;
                            }
                            holder.getField().set(holder.getField().getClass(), value);
                            break;
                        }
                        case LONG: {
                            if (holder.isInstanced()) {
                                holder.getField().set(holder.getObjectSource(), value);
                                break;
                            }
                            holder.getField().set(holder.getField().getClass(), value);
                            break;
                        }
                        case STRING: {
                            if (holder.isInstanced()) {
                                holder.getField().set(holder.getObjectSource(), value);
                                break;
                            }
                            holder.getField().set(holder.getField().getClass(), value);
                            break;
                        }
                        case BOOLEAN: {
                            if (holder.isInstanced()) {
                                holder.getField().set(holder.getObjectSource(), value == null ? Boolean.valueOf(true) : value);
                                break;
                            }
                            holder.getField().set(holder.getField().getClass(), value == null ? Boolean.valueOf(true) : value);
                            break;
                        }
                        case ENUM: {
                            if (holder.isInstanced()) {
                                try {
                                    holder.getField().set(holder.getObjectSource(), value);
                                    break;
                                }
                                catch (Exception e) {
                                    throw new IllegalArgumentException("Option given is not a valid option. Valid options are: " + this.enumOptions.get(holder.flag.options()).toString() + ".");
                                }
                            }
                            try {
                                holder.getField().set(holder.getField().getClass(), value);
                                break;
                            }
                            catch (Exception e) {
                                throw new IllegalArgumentException("Option given is not a valid option. Valid options are: " + this.enumOptions.get(holder.flag.options()).toString() + ".");
                            }
                        }
                    }
                    continue;
                }
                if (!holder.getFlag().required()) continue;
                throw new IllegalArgumentException("Required argument missing: " + holder.getFlag().name());
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException("Programming error, illegal access for " + holder.getField().toGenericString());
            }
        }
        try {
            this.callPostConstructMethods();
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException("Post construct method thrown exception", e.getCause());
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException("Programming error, illegal access to a post construct method", e);
        }
        return this;
    }

    private void callPostConstructMethods() throws InvocationTargetException, IllegalAccessException {
        for (Object object : this.objects) {
            for (Method method : this.findPostConstructMethod(object.getClass(), true)) {
                method.invoke(object, new Object[0]);
            }
        }
        for (Class clazz : this.classes) {
            for (Method method : this.findPostConstructMethod(clazz, false)) {
                method.invoke((Object)false, new Object[0]);
            }
        }
    }

    private List<Method> findPostConstructMethod(Class<?> type, boolean instanced) {
        ArrayList<Method> result = new ArrayList<Method>();
        for (Method method : type.getDeclaredMethods()) {
            if (method.getAnnotation(PostConstruct.class) == null) continue;
            boolean isStatic = Modifier.isStatic(method.getModifiers());
            if ((!instanced || isStatic) && (instanced || !isStatic)) continue;
            this.checkNoMethodArguments(method);
            if (!method.isAccessible()) {
                method.setAccessible(true);
            }
            result.add(method);
        }
        return result;
    }

    private void checkNoMethodArguments(Method method) {
        if (method.getParameterTypes().length != 0) {
            String methodName = method.getDeclaringClass().getName() + "#" + method.getName();
            throw new IllegalArgumentException("Post construct method " + methodName + " must not have parameters");
        }
    }

    public void printHelp(OutputStream out) {
        LinkedList<OptionHolder> holderList;
        String className;
        PrintWriter w = new PrintWriter(out);
        TreeMap<String, LinkedList<OptionHolder>> holdersByClass = new TreeMap<String, LinkedList<OptionHolder>>();
        for (OptionHolder optionHolder : this.options.values()) {
            className = optionHolder.isInstanced() ? optionHolder.getObjectSource().getClass().getName() : optionHolder.getClassSource().getName();
            holderList = (LinkedList<OptionHolder>)holdersByClass.get(className);
            if (null == holderList) {
                holderList = new LinkedList<OptionHolder>();
                holdersByClass.put(className, holderList);
            }
            holderList.add(optionHolder);
        }
        for (Map.Entry entry : holdersByClass.entrySet()) {
            className = (String)entry.getKey();
            holderList = (List)entry.getValue();
            Collections.sort(holderList, new Comparator<OptionHolder>(){

                @Override
                public int compare(OptionHolder a, OptionHolder b) {
                    return a.getFlag().name().toLowerCase().compareTo(b.getFlag().name().toLowerCase());
                }
            });
            StringBuffer buff = new StringBuffer();
            buff.append("\n\n").append(className).append("\n").append("------------------------------------------------------------------------").append("\n");
            for (OptionHolder holder : holderList) {
                int spaces;
                String s;
                buff.append(holder.getFlag().required() ? "* " : "  ");
                try {
                    s = "  --" + holder.getFlag().name() + " <" + (Object)((Object)holder.getType()) + "> default: " + (holder.isInstanced() ? holder.getField().get(holder.getObjectSource()) : holder.getField().get(holder.getClassSource()));
                }
                catch (IllegalAccessException e) {
                    throw new RuntimeException(e);
                }
                if (holder.getFlag().options() != NoOption.class) {
                    s = s + " options: " + this.enumOptions.get(holder.getFlag().options()).toString();
                }
                spaces = (spaces = 50 - s.length()) < 0 ? 0 : spaces;
                buff.append(s).append("  . . . . . . . . . . . . . . . . . . . . . . . . ".substring(0, spaces)).append("| " + holder.getFlag().description()).append("\n");
            }
            w.println(buff.toString());
        }
        w.flush();
    }

    public void printVersion(OutputStream out) {
        PrintWriter w = new PrintWriter(out);
        w.println(this.versionString);
        w.flush();
    }

    public boolean helpFlagged() {
        return this.optionSet.has(this.help);
    }

    public boolean versionFlagged() {
        return this.optionSet.has(this.version);
    }

    public boolean propertiesFlagged() {
        return this.optionSet.hasArgument(this.propertiesFile);
    }

    public void printFlags() {
        try {
            for (OptionHolder holder : this.options.values()) {
                System.out.println("Field: " + holder.getField().toGenericString() + "\nFlag: name:" + holder.getFlag().name() + ", description:" + holder.getFlag().description() + ", type:" + (Object)((Object)holder.getType()) + ", default:" + (holder.isInstanced() ? holder.getField().get(holder.getObjectSource()) : holder.getField().get(holder.getClassSource())));
            }
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    private static FieldType fieldTypeOf(Field field, Flag flag) {
        if (field.getType().isAssignableFrom(Long.TYPE) || field.getType().isAssignableFrom(Long.class)) {
            return FieldType.LONG;
        }
        if (field.getType().isAssignableFrom(Boolean.TYPE) || field.getType().isAssignableFrom(Boolean.class)) {
            return FieldType.BOOLEAN;
        }
        if (field.getType().isAssignableFrom(String.class)) {
            return FieldType.STRING;
        }
        if (field.getType().isAssignableFrom(Integer.TYPE) || field.getType().isAssignableFrom(Integer.class)) {
            return FieldType.INTEGER;
        }
        if (flag.options() != NoOption.class && field.getType().isAssignableFrom(flag.options())) {
            return FieldType.ENUM;
        }
        return FieldType.UNKNOWN;
    }

    public List<Flag> getFlagsAsList() {
        ArrayList<Flag> list = new ArrayList<Flag>();
        for (OptionHolder holder : this.options.values()) {
            list.add(holder.getFlag());
        }
        return list;
    }

    private static class OptionHolder {
        private final Flag flag;
        private final Field field;
        private final OptionSpec<?> optionSpec;
        private final FieldType type;
        private final Class<?> classSource;
        private final Object objectSource;

        OptionHolder(FieldType type, Flag flag, Field field, OptionSpec<?> optionSpec, Class<?> classSource) {
            this.type = type;
            this.flag = flag;
            this.field = field;
            this.optionSpec = optionSpec;
            this.classSource = classSource;
            this.objectSource = null;
        }

        OptionHolder(FieldType type, Flag flag, Field field, OptionSpec<?> optionSpec, Object objectSource) {
            this.type = type;
            this.flag = flag;
            this.field = field;
            this.optionSpec = optionSpec;
            this.objectSource = objectSource;
            this.classSource = null;
        }

        public boolean isInstanced() {
            return this.objectSource != null;
        }

        public Flag getFlag() {
            return this.flag;
        }

        public Field getField() {
            if (!this.field.isAccessible()) {
                this.field.setAccessible(true);
            }
            return this.field;
        }

        public OptionSpec<?> getOptionSpec() {
            return this.optionSpec;
        }

        public FieldType getType() {
            return this.type;
        }

        public Class<?> getClassSource() {
            return this.classSource;
        }

        public Object getObjectSource() {
            return this.objectSource;
        }
    }

    private static enum FieldType {
        ENUM,
        STRING,
        INTEGER,
        LONG,
        BOOLEAN,
        UNKNOWN;

    }
}

