/*
 * Decompiled with CFR 0.152.
 */
package com.github.segmentio;

import com.github.segmentio.Client;
import com.github.segmentio.Options;
import com.github.segmentio.models.BasePayload;
import com.github.segmentio.models.Callback;
import com.github.segmentio.models.Context;
import com.github.segmentio.models.EventProperties;
import com.github.segmentio.models.Traits;
import org.joda.time.DateTime;

public class Analytics {
    private static Client defaultClient;

    public static void initialize(String secret) {
        defaultClient = new Client(secret, new Options());
    }

    public static void initialize(String secret, Options options) {
        defaultClient = new Client(secret, options);
    }

    private static void checkInitialized() {
        if (defaultClient == null) {
            throw new IllegalStateException("Analytics client is not initialized. Please call Analytics.iniitalize(..); before calling identify / track / or flush.");
        }
    }

    public static void identify(String userId, Traits traits) {
        Analytics.checkInitialized();
        defaultClient.identify(userId, traits, null, null, null);
    }

    public static void identify(String userId, Traits traits, Context context) {
        Analytics.checkInitialized();
        defaultClient.identify(userId, traits, null, context, null);
    }

    public static void identify(String userId, Traits traits, DateTime timestamp, Context context) {
        Analytics.checkInitialized();
        defaultClient.identify(userId, traits, timestamp, context, null);
    }

    public static void identify(String userId, Traits traits, DateTime timestamp, Context context, Callback callback) {
        Analytics.checkInitialized();
        defaultClient.identify(userId, traits, timestamp, context, callback);
    }

    public static void track(String userId, String event, EventProperties properties) {
        Analytics.checkInitialized();
        defaultClient.track(userId, event, properties, null, null, null);
    }

    public static void track(String userId, String event) {
        Analytics.checkInitialized();
        defaultClient.track(userId, event, null, null, null, null);
    }

    public static void track(String userId, String event, EventProperties properties, DateTime timestamp) {
        Analytics.checkInitialized();
        defaultClient.track(userId, event, properties, timestamp, null, null);
    }

    public static void track(String userId, String event, EventProperties properties, DateTime timestamp, Context context) {
        Analytics.checkInitialized();
        defaultClient.track(userId, event, properties, timestamp, context, null);
    }

    public static void track(String userId, String event, EventProperties properties, DateTime timestamp, Context context, Callback callback) {
        Analytics.checkInitialized();
        defaultClient.track(userId, event, properties, timestamp, context, callback);
    }

    public void enqueue(BasePayload payload) {
        defaultClient.enqueue(payload);
    }

    public static void flush() {
        Analytics.checkInitialized();
        defaultClient.flush();
    }

    public static void close() {
        Analytics.checkInitialized();
        defaultClient.close();
    }

    public static Client getDefaultClient() {
        return defaultClient;
    }
}

