/*
 * Decompiled with CFR 0.152.
 */
package com.github.segmentio;

import com.github.segmentio.Options;
import com.github.segmentio.gson.DateTimeTypeConverter;
import com.github.segmentio.models.BasePayload;
import com.github.segmentio.models.Batch;
import com.github.segmentio.models.Callback;
import com.github.segmentio.models.Context;
import com.github.segmentio.models.EventProperties;
import com.github.segmentio.models.Identify;
import com.github.segmentio.models.Track;
import com.github.segmentio.models.Traits;
import com.github.segmentio.safeclient.AsyncHttpBatchedOperation;
import com.github.segmentio.safeclient.policy.flush.FlushAfterTimePolicy;
import com.github.segmentio.safeclient.policy.flush.FlushAtSizePolicy;
import com.github.segmentio.safeclient.policy.flush.IFlushPolicy;
import com.github.segmentio.safeclient.utils.Statistics;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.ning.http.client.AsyncHttpClient;
import com.ning.http.client.Request;
import com.ning.http.client.RequestBuilder;
import com.ning.http.client.Response;
import java.io.UnsupportedEncodingException;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.joda.time.DateTime;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Client {
    private String secret;
    private Options options;
    private Gson gson;
    private AsyncHttpBatchedOperation<BasePayload> operation;

    public Client(String secret) {
        this(secret, new Options());
    }

    public Client(String secret, Options options) {
        String errorPrefix = "analytics-java client must be initialized with a valid ";
        if (StringUtils.isEmpty((String)secret)) {
            throw new IllegalArgumentException(errorPrefix + "secret.");
        }
        if (options == null) {
            throw new IllegalArgumentException(errorPrefix + "options.");
        }
        this.secret = secret;
        this.options = options;
        this.gson = new GsonBuilder().registerTypeAdapter(DateTime.class, (Object)new DateTimeTypeConverter()).create();
        this.operation = this.buildOperation(new AsyncHttpClient(options.getHttpConfig()));
    }

    public void identify(String userId, Traits traits) {
        this.identify(userId, traits, null, null, null);
    }

    public void identify(String userId, Traits traits, Context context) {
        this.identify(userId, traits, null, context, null);
    }

    public void identify(String userId, Traits traits, DateTime timestamp, Context context) {
        this.identify(userId, traits, timestamp, context, null);
    }

    public void identify(String userId, Traits traits, DateTime timestamp, Context context, Callback callback) {
        if (context == null) {
            context = new Context();
        }
        if (traits == null) {
            traits = new Traits();
        }
        Identify identify = new Identify(userId, traits, timestamp, context, callback);
        this.operation.perform(identify);
    }

    public void enqueue(BasePayload payload) {
        this.operation.perform(payload);
    }

    public void track(String userId, String event) {
        this.track(userId, event, null, null, null, null);
    }

    public void track(String userId, String event, EventProperties properties) {
        this.track(userId, event, properties, null, null, null);
    }

    public void track(String userId, String event, EventProperties properties, DateTime timestamp) {
        this.track(userId, event, properties, timestamp, null, null);
    }

    public void track(String userId, String event, EventProperties properties, DateTime timestamp, Context context) {
        this.track(userId, event, properties, timestamp, context, null);
    }

    public void track(String userId, String event, EventProperties properties, DateTime timestamp, Context context, Callback callback) {
        if (context == null) {
            context = new Context();
        }
        if (properties == null) {
            properties = new EventProperties(new Object[0]);
        }
        Track track = new Track(userId, event, properties, timestamp, context, callback);
        this.operation.perform(track);
    }

    public void flush() {
        this.operation.flush();
    }

    public void close() {
        this.operation.close();
    }

    public String getSecret() {
        return this.secret;
    }

    public void setSecret(String secret) {
        this.secret = secret;
    }

    public Options getOptions() {
        return this.options;
    }

    public Statistics getStatistics() {
        return this.operation.statistics;
    }

    public AsyncHttpBatchedOperation<BasePayload> buildOperation(AsyncHttpClient client) {
        return new AsyncHttpBatchedOperation<BasePayload>(client){

            @Override
            protected int getMaxQueueSize() {
                return Client.this.options.getMaxQueueSize();
            }

            @Override
            protected Iterable<IFlushPolicy> createFlushPolicies() {
                return Arrays.asList(new FlushAfterTimePolicy(Client.this.options.getFlushAfter()), new FlushAtSizePolicy(Client.this.options.getFlushAt()));
            }

            @Override
            public Request buildRequest(List<BasePayload> batch) {
                Batch model = new Batch(Client.this.secret, batch);
                String json = Client.this.gson.toJson((Object)model);
                try {
                    return new RequestBuilder().setMethod("POST").setBody(json.getBytes("UTF-8")).addHeader("Content-Type", "application/json; charset=utf-8").setUrl(Client.this.options.getHost() + "/v1/import").build();
                }
                catch (IllegalArgumentException e) {
                    e.printStackTrace();
                }
                catch (UnsupportedEncodingException e) {
                    e.printStackTrace();
                }
                return null;
            }

            @Override
            public void onFlush(List<BasePayload> batch, Response response) {
                for (BasePayload payload : batch) {
                    Callback callback = payload.getCallback();
                    if (callback == null) continue;
                    callback.onResponse(response);
                }
            }
        };
    }
}

