/*
 * Decompiled with CFR 0.152.
 */
package com.github.segmentio.safeclient;

import com.github.segmentio.safeclient.BatchedOperation;
import com.ning.http.client.AsyncCompletionHandler;
import com.ning.http.client.AsyncHandler;
import com.ning.http.client.AsyncHttpClient;
import com.ning.http.client.AsyncHttpClientConfig;
import com.ning.http.client.Request;
import com.ning.http.client.Response;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AsyncHttpBatchedOperation<M>
extends BatchedOperation<M> {
    private static final Logger logger = LoggerFactory.getLogger(AsyncHttpBatchedOperation.class);
    private AsyncHttpClient asyncHttpClient;
    private int maximumOutstandingConnections;
    private AtomicInteger outstanding;

    public AsyncHttpBatchedOperation() {
        this.maximumOutstandingConnections = 100;
        this.outstanding = new AtomicInteger(0);
        this.asyncHttpClient = new AsyncHttpClient(new AsyncHttpClientConfig.Builder().setMaxRequestRetry(1).setIdleConnectionTimeoutInMs(30000).setMaximumConnectionsTotal(this.maximumOutstandingConnections).setAllowPoolingConnection(true).build());
        if (this.maximumOutstandingConnections < 1) {
            throw new IllegalArgumentException("Outstanding connections must be greater than 0.");
        }
    }

    public AsyncHttpBatchedOperation(AsyncHttpClient client) {
        this.asyncHttpClient = client;
        this.maximumOutstandingConnections = client.getConfig().getMaxTotalConnections();
        this.outstanding = new AtomicInteger(0);
        if (this.maximumOutstandingConnections < 1) {
            throw new IllegalArgumentException("Outstanding connections must be greater than 0.");
        }
    }

    public abstract Request buildRequest(List<M> var1);

    @Override
    public boolean canFlush() {
        return this.outstanding.get() < this.maximumOutstandingConnections;
    }

    @Override
    public void performFlush(final List<M> batch) {
        Request request = this.buildRequest(batch);
        this.statistics.update("Request Body Size (bytes)", request.getContentLength());
        this.outstanding.incrementAndGet();
        try {
            final long start = System.currentTimeMillis();
            this.asyncHttpClient.executeRequest(request, (AsyncHandler)new AsyncCompletionHandler<Response>(){

                public Response onCompleted(Response response) throws Exception {
                    AsyncHttpBatchedOperation.this.outstanding.decrementAndGet();
                    long duration = System.currentTimeMillis() - start;
                    AsyncHttpBatchedOperation.this.statistics.update("Request Duration (ms)", duration);
                    int statusCode = response.getStatusCode();
                    if (statusCode == 200) {
                        AsyncHttpBatchedOperation.this.statistics.update("Successful Requests", 1.0);
                    } else {
                        if (AsyncHttpBatchedOperation.this.errorLoggingRateLimit.canPerform()) {
                            logger.error("Response [code = " + statusCode + "]. Response = " + response.getResponseBody());
                        }
                        AsyncHttpBatchedOperation.this.statistics.update("Failed Requests", 1.0);
                    }
                    AsyncHttpBatchedOperation.this.onFlush(batch, response);
                    return response;
                }
            });
        }
        catch (IOException e) {
            if (this.errorLoggingRateLimit.canPerform()) {
                logger.error("Async HTTP flush failed.", (Throwable)e);
            }
            this.outstanding.decrementAndGet();
        }
    }

    public void onFlush(List<M> batch, Response response) {
    }
}

