/*
 * Decompiled with CFR 0.152.
 */
package com.github.segmentio.safeclient;

import com.github.segmentio.safeclient.flusher.IFlusher;
import com.github.segmentio.safeclient.flusher.ThreadPoolFlusher;
import com.github.segmentio.safeclient.policy.flush.FlushAfterTimePolicy;
import com.github.segmentio.safeclient.policy.flush.FlushAtSizePolicy;
import com.github.segmentio.safeclient.policy.flush.IFlushPolicy;
import com.github.segmentio.safeclient.policy.queue.DenyAfterCapacityPolicy;
import com.github.segmentio.safeclient.policy.queue.IQueueDenyPolicy;
import com.github.segmentio.safeclient.queue.IBatchQueue;
import com.github.segmentio.safeclient.queue.NonLockingQueue;
import com.github.segmentio.safeclient.utils.RateLimit;
import com.github.segmentio.safeclient.utils.Statistics;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BatchedOperation<M> {
    private static final Logger logger = LoggerFactory.getLogger(BatchedOperation.class);
    protected Iterable<IFlushPolicy> flushPolicies = this.createFlushPolicies();
    protected Iterable<IQueueDenyPolicy> denyPolicies = this.createCapacityPolicies();
    private IFlusher flusher = this.createFlusher();
    private IBatchQueue<M> queue = this.createQueue();
    protected RateLimit errorLoggingRateLimit = new RateLimit(1, 1000);
    protected RateLimit statisticsLoggingRateLimit = new RateLimit(1, 5000);
    private DateTime lastFlush;
    public Statistics statistics = new Statistics();

    public abstract boolean canFlush();

    public abstract void performFlush(List<M> var1);

    public boolean perform(M message) {
        boolean canEnqueue = true;
        int currentSize = this.queue.size();
        for (IQueueDenyPolicy denyPolicy : this.denyPolicies) {
            if (denyPolicy.canQueue(currentSize)) continue;
            canEnqueue = false;
            this.statistics.update("Queue over Capacity => Denied Message", 1.0);
            break;
        }
        if (canEnqueue) {
            currentSize = this.queue.add(message);
            this.statistics.update("Enqueued Message", 1.0);
        } else if (this.errorLoggingRateLimit.canPerform()) {
            logger.warn("Operation batch queue is full, and flushing operations are also pending. Choosing to drop this message from the queue.");
        }
        if (this.canFlush()) {
            for (IFlushPolicy flushPolicy : this.flushPolicies) {
                if (!flushPolicy.shouldFlush(currentSize, this.lastFlush)) continue;
                this.statistics.update("Asking to Flush", 1.0);
                this.flush();
                break;
            }
        } else {
            if (this.errorLoggingRateLimit.canPerform()) {
                logger.warn("Batched operation can't flush.");
            }
            this.statistics.update("Batched Operation Can't Flush", 1.0);
        }
        this.statistics.update("Queue Size", this.queue.size());
        if (this.shouldLogStatistics() && this.statisticsLoggingRateLimit.canPerform()) {
            logger.debug(this.statistics.toString());
        }
        return canEnqueue;
    }

    public boolean flush() {
        if (this.flusher.canFlush()) {
            int maxAmount = this.getMaxFlushAmount();
            List<M> batch = this.queue.flush(maxAmount);
            if (batch != null) {
                this.flusher.flush(this, batch);
                this.statistics.update("Flushes", 1.0);
                this.statistics.update("Flush Batch Size", batch.size());
                this.lastFlush = new DateTime(DateTimeZone.UTC);
                return true;
            }
        } else {
            this.statistics.update("Flusher Can't Flush", 1.0);
        }
        return false;
    }

    public int getQueueSize() {
        return this.queue.size();
    }

    public boolean shouldLogStatistics() {
        return true;
    }

    protected int getMaxFlushAmount() {
        return 50;
    }

    protected int getMaxQueueSize() {
        return this.getMaxFlushAmount() * 20;
    }

    protected Iterable<IFlushPolicy> createFlushPolicies() {
        return Arrays.asList(new FlushAfterTimePolicy(10000L), new FlushAtSizePolicy(this.getMaxFlushAmount()));
    }

    protected Iterable<IQueueDenyPolicy> createCapacityPolicies() {
        LinkedList<IQueueDenyPolicy> policies = new LinkedList<IQueueDenyPolicy>();
        policies.add(new DenyAfterCapacityPolicy(this.getMaxQueueSize()));
        return policies;
    }

    protected IFlusher createFlusher() {
        return new ThreadPoolFlusher(0, 1, 1000);
    }

    protected IBatchQueue<M> createQueue() {
        return new NonLockingQueue();
    }

    public void clear() {
        if (this.queue != null) {
            this.queue.clear();
        }
    }

    public void close() {
        if (this.flusher != null) {
            this.flusher.close();
        }
        if (this.queue != null) {
            this.queue.clear();
        }
    }
}

