/*
 * Decompiled with CFR 0.152.
 */
package com.github.segmentio.safeclient.flusher;

import com.github.segmentio.safeclient.BatchedOperation;
import com.github.segmentio.safeclient.flusher.IFlusher;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.util.List;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ThreadPoolFlusher
implements IFlusher {
    private static final Logger logger = LoggerFactory.getLogger(ThreadPoolFlusher.class);
    private ThreadPoolExecutor executor;
    private int maxRunnableQueueSize;

    public ThreadPoolFlusher(int coreThreads, int maxThreads, int maxRunnableQueueSize) {
        this.maxRunnableQueueSize = maxRunnableQueueSize;
        this.executor = ThreadPoolFlusher.createNamedFixedBoundedThreadPool(coreThreads, maxThreads, maxRunnableQueueSize, "SafeClient - ThreadPoolFlusher");
    }

    @Override
    public boolean canFlush() {
        return this.executor.getQueue().size() < Math.max(1, this.maxRunnableQueueSize / 2);
    }

    @Override
    public <M> void flush(final BatchedOperation<M> operation, final List<M> batch) {
        try {
            this.executor.execute(new Runnable(){

                public void run() {
                    operation.performFlush(batch);
                }
            });
        }
        catch (RejectedExecutionException e) {
            logger.error("Thread pool flusher can not keep up to the flush rate, dropping flush batch.", (Throwable)e);
        }
    }

    private static ThreadFactoryBuilder createThreadPoolBuilder(String threadPoolName) {
        ThreadFactoryBuilder builder = new ThreadFactoryBuilder();
        builder.setNameFormat(threadPoolName + "-%d");
        builder.setUncaughtExceptionHandler(new Thread.UncaughtExceptionHandler(){

            public void uncaughtException(Thread t, Throwable e) {
                logger.error(String.format("Uncaught thread pool exception in thread %s and exception %s.", String.format("%s-%s", t.getThreadGroup().getName(), t.getName()), e.getMessage()), e);
            }
        });
        return builder;
    }

    public static ThreadPoolExecutor createNamedFixedBoundedThreadPool(int corePoolSize, int maxPoolSize, int maxRunnableQueueSize, String threadPoolName) {
        ThreadFactoryBuilder builder = ThreadPoolFlusher.createThreadPoolBuilder(threadPoolName);
        ThreadPoolExecutor executor = new ThreadPoolExecutor(corePoolSize, maxPoolSize, 5L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(maxRunnableQueueSize), builder.build());
        return executor;
    }

    @Override
    public void close() {
        if (this.executor != null) {
            this.executor.shutdown();
        }
    }
}

