/*
 * Decompiled with CFR 0.152.
 */
package com.github.segmentio.safeclient.queue;

import com.github.segmentio.safeclient.queue.IBatchQueue;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NonLockingQueue<T>
implements IBatchQueue<T> {
    private ConcurrentLinkedQueue<T> queue = new ConcurrentLinkedQueue();
    private AtomicBoolean lock = new AtomicBoolean(false);
    private AtomicInteger count = new AtomicInteger(0);

    @Override
    public int add(T item) {
        int size = -1;
        size = this.queue.add(item) ? this.count.addAndGet(1) : this.count.get();
        return size;
    }

    @Override
    public int size() {
        return this.count.get();
    }

    @Override
    public List<T> flush(int maxAmount) {
        LinkedList<T> list = null;
        if (this.lock.compareAndSet(false, true)) {
            int flushed = 0;
            list = new LinkedList<T>();
            T item = this.queue.poll();
            while (item != null) {
                list.add(item);
                if (++flushed > maxAmount) break;
                item = this.queue.poll();
            }
            this.count.addAndGet(-list.size());
            this.lock.set(false);
        }
        return list;
    }

    @Override
    public void clear() {
        this.queue.clear();
        this.count.set(0);
    }
}

