/*
 * Decompiled with CFR 0.152.
 */
package com.github.segmentio.safeclient.utils;

import com.google.common.util.concurrent.AtomicDouble;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;

public class RateLimit {
    private int allowed;
    private int perMilliseconds;
    private AtomicDouble allowance;
    private AtomicLong lastCheck;
    private AtomicBoolean lock;

    public RateLimit(int allowed, int perMilliseconds) {
        this.allowed = allowed;
        this.perMilliseconds = perMilliseconds;
        this.allowance = new AtomicDouble((double)allowed);
        this.lastCheck = new AtomicLong(System.currentTimeMillis());
        this.lock = new AtomicBoolean(false);
    }

    public double getRate() {
        return (double)this.allowed / (double)this.perMilliseconds;
    }

    public boolean canPerform() {
        boolean canPerform = false;
        if (this.lock.compareAndSet(false, true)) {
            long current = System.currentTimeMillis();
            long timePassed = current - this.lastCheck.get();
            this.lastCheck.set(current);
            double delta = (double)timePassed * ((double)this.allowed / (double)this.perMilliseconds);
            double allowanceVal = this.allowance.addAndGet(delta);
            if (allowanceVal > (double)this.allowed) {
                this.allowance.set((double)this.allowed);
            }
            if (allowanceVal < 1.0) {
                canPerform = false;
            } else {
                this.allowance.addAndGet(-1.0);
                canPerform = true;
            }
            this.lock.set(false);
        }
        return canPerform;
    }
}

