/*
 * Decompiled with CFR 0.152.
 */
package com.sio;

import com.ning.http.client.AsyncHttpClient;
import com.sio.Context;
import com.sio.EventProperties;
import com.sio.Traits;
import org.apache.commons.lang.StringUtils;
import org.joda.time.DateTime;

public class Segmentio {
    private String apiKey;
    private String environment;
    private AsyncHttpClient client;
    private boolean secure;
    private String host;

    public Segmentio(String apiKey) {
        this(apiKey, "development", new AsyncHttpClient(), true);
    }

    public Segmentio(String apiKey, String environment) {
        this(apiKey, environment, new AsyncHttpClient(), true);
    }

    public Segmentio(String apiKey, boolean secure) {
        this(apiKey, "development", new AsyncHttpClient(), secure);
    }

    public Segmentio(String apiKey, String environment, boolean secure) {
        this(apiKey, environment, new AsyncHttpClient(), secure);
    }

    public Segmentio(String apiKey, String environment, AsyncHttpClient client) {
        this(apiKey, environment, client, true);
    }

    public Segmentio(String apiKey, String environment, AsyncHttpClient client, boolean secure) {
        String errorPrefix = "Segmentio client must be initialized with a valid ";
        if (StringUtils.isEmpty((String)apiKey)) {
            throw new IllegalArgumentException(errorPrefix + "apiKey.");
        }
        if (StringUtils.isEmpty((String)environment)) {
            throw new IllegalArgumentException(errorPrefix + "environment.");
        }
        if (client == null) {
            throw new IllegalArgumentException(errorPrefix + "client.");
        }
        this.apiKey = apiKey;
        this.environment = environment;
        this.client = client;
        this.secure = secure;
    }

    Segmentio(String apiKey, String environment, AsyncHttpClient client, boolean secure, String host) {
        this(apiKey, environment, client, secure);
        if (StringUtils.isEmpty((String)host)) {
            throw new IllegalArgumentException("Host required.");
        }
        this.host = host;
    }

    public void identify(String sessionId, String visitorId, Context context, Object ... traits) {
        this.identify(sessionId, visitorId, context, null, new Traits(traits));
    }

    public void identify(String sessionId, String visitorId, Context context, DateTime timestamp, Traits traits) {
    }

    public void track(String visitorId, String event, Object ... properties) {
        this.track(visitorId, event, null, new EventProperties(properties));
    }

    public void track(String visitorId, String event, DateTime timestamp, EventProperties properties) {
    }

    public String getApiKey() {
        return this.apiKey;
    }

    public void setApiKey(String apiKey) {
        this.apiKey = apiKey;
    }

    public String getEnvironment() {
        return this.environment;
    }

    public void setEnvironment(String environment) {
        this.environment = environment;
    }

    public AsyncHttpClient getClient() {
        return this.client;
    }

    public String getHost() {
        return this.host;
    }

    public static class Defaults {
        private static final boolean SECURE = true;
        private static final String ENVIRONMENT = "development";
        private static final String HOST = "api.segment.io";
    }
}

