/*
 * Decompiled with CFR 0.152.
 */
package seleniumConsulting.ch.selenium.framework.driver;

import java.util.HashMap;
import java.util.Map;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.remote.RemoteWebDriver;
import org.openqa.selenium.remote.SessionId;
import org.openqa.selenium.support.events.EventFiringWebDriver;
import seleniumConsulting.ch.selenium.framework.driver.WebDriverFactory;
import seleniumConsulting.ch.selenium.framework.listeners.webdriver.WebDriverEventListener;
import seleniumConsulting.ch.selenium.framework.metadata.MetadataManager;
import vendors.grid.TestInfo;

public class WebDriverManager {
    private static Map<Long, WebDriver> webDriverMap = new HashMap<Long, WebDriver>();
    private static Map<Long, SessionId> webDriverSessionIDMap = new HashMap<Long, SessionId>();

    public static WebDriver getWebdriver() {
        return webDriverMap.get(Thread.currentThread().getId());
    }

    public static SessionId getWebdriverSessionId() {
        return webDriverSessionIDMap.get(Thread.currentThread().getId());
    }

    public static WebDriver createWebDriver(TestInfo testinfo) {
        WebDriver webDriver = WebDriverFactory.createDriver((String)MetadataManager.getMetadata(testinfo, "browser_name"), (String)MetadataManager.getMetadata(testinfo, "browser_version"), (Map)MetadataManager.getMetadata(testinfo, "capabilities"), testinfo);
        EventFiringWebDriver driver = new EventFiringWebDriver(webDriver);
        WebDriverEventListener webDriverEventListener = new WebDriverEventListener();
        driver.register((org.openqa.selenium.support.events.WebDriverEventListener)webDriverEventListener);
        if (webDriver instanceof RemoteWebDriver) {
            webDriverSessionIDMap.put(Thread.currentThread().getId(), ((RemoteWebDriver)webDriver).getSessionId());
        }
        WebDriverManager.webDriverMapPut((WebDriver)driver);
        return driver;
    }

    public static void quitWebDriver() {
        WebDriverManager.getWebdriver().quit();
        webDriverMap.remove(Thread.currentThread().getId());
        webDriverSessionIDMap.remove(Thread.currentThread().getId());
    }

    private static void webDriverMapPut(WebDriver driver) {
        webDriverMap.put(Thread.currentThread().getId(), driver);
    }
}

