/*
 * Decompiled with CFR 0.152.
 */
package seleniumConsulting.ch.selenium.framework.dataLoader;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import seleniumConsulting.ch.selenium.framework.allure.AllureTextEnum;

public class TestDataProvider {
    private static final Logger LOGGER = LoggerFactory.getLogger(TestDataProvider.class);
    private static final String FOLDER_TESTDATA_PROPERTIES = "testdata/";
    private static final String FOLDER_TESTCONFIG_PROPERTIES = "testconfig/";
    private static final String FILE_TESTDATA_PROPERTIES = "data.properties";
    private static final String FILE_TESTCONFIG_PROPERTIES = "data.properties";
    private static final String FILE_ALLURETEXT_PROPERTIES = "allureText.properties";
    public static final String USER_NAME = "user.name";
    private Properties testDataProperties = TestDataProvider.loadConfigAndSetAsSystemProperties("testconfig/", "data.properties", false);
    private static TestDataProvider instance = null;

    public static TestDataProvider getInstance() {
        if (instance == null) {
            instance = new TestDataProvider();
        }
        return instance;
    }

    private TestDataProvider() {
        this.testDataProperties.putAll((Map<?, ?>)TestDataProvider.loadConfigAndSetAsSystemProperties(FOLDER_TESTDATA_PROPERTIES, "data.properties", false));
        this.testDataProperties.putAll((Map<?, ?>)TestDataProvider.loadConfigAndSetAsSystemProperties("", FILE_ALLURETEXT_PROPERTIES, true));
        this.testDataProperties.putAll((Map<?, ?>)TestDataProvider.loadConfigAndSetAsSystemProperties(FOLDER_TESTCONFIG_PROPERTIES, FILE_ALLURETEXT_PROPERTIES, false));
    }

    public static String getTestData(String key) {
        try {
            return TestDataProvider.getInstance().getTestDataProperties().get(key).toString();
        }
        catch (NullPointerException e) {
            LOGGER.info("TestDataProvider.getTestData: NullPointer, key:(" + key + ") and returns \"\"");
            return "";
        }
    }

    public static String getTestData(AllureTextEnum key) {
        try {
            return TestDataProvider.getInstance().getTestDataProperties().get(key.getValue()).toString();
        }
        catch (NullPointerException e) {
            return "";
        }
    }

    private static Properties loadConfigAndSetAsSystemProperties(String folder, String propertieFileName, boolean fromToolkit) {
        Properties props = TestDataProvider.loadConfig(folder, propertieFileName, fromToolkit);
        Iterator<Map.Entry<Object, Object>> iterator = props.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<Object, Object> o;
            Map.Entry<Object, Object> entry = o = iterator.next();
            System.setProperty((String)entry.getKey(), (String)entry.getValue());
        }
        return props;
    }

    private static Properties loadConfig(String folder, String propertieFileName, boolean fromToolkit) {
        String defaultProps = folder + propertieFileName;
        Properties properties = TestDataProvider.loadProperties(defaultProps, fromToolkit);
        String filename = folder + System.getProperties().getProperty(USER_NAME) + "." + propertieFileName;
        Properties userProperties = TestDataProvider.loadProperties(filename, fromToolkit);
        if (userProperties != null) {
            properties.putAll((Map<?, ?>)userProperties);
        }
        return properties;
    }

    private static Properties loadProperties(String name, boolean fromToolkit) {
        ClassLoader loader = fromToolkit ? TestDataProvider.class.getClassLoader() : Thread.currentThread().getContextClassLoader();
        URL url = loader.getResource(name);
        Properties props = new Properties();
        if (url != null) {
            try {
                InputStream e = url.openStream();
                props.load(e);
            }
            catch (IOException e) {
                LOGGER.error("TestDataProvider.loadProperties faild. Exception-Message:" + e.getMessage());
            }
        }
        return props;
    }

    private Properties getTestDataProperties() {
        return this.testDataProperties;
    }
}

