/*
 * Decompiled with CFR 0.152.
 */
package seleniumConsulting.ch.selenium.framework.dataLoader;

import com.google.common.base.Strings;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import seleniumConsulting.ch.selenium.framework.allure.AllureTextEnum;

public class TestDataProvider {
    private static final Logger LOGGER = LoggerFactory.getLogger(TestDataProvider.class);
    private static final String FOLDER_TESTDATA_PROPERTIES = "testdata/";
    private static final String FOLDER_TESTCONFIG_PROPERTIES = "testconfig/";
    private static final String FILE_TESTDATA_PROPERTIES = "data.properties";
    private static final String FILE_TESTCONFIG_PROPERTIES = "data.properties";
    private static final String FILE_ALLURETEXT_PROPERTIES = "allureText.properties";
    public static final String USER_NAME = "user.name";
    public static final String TARGET_ENV = "target.env";
    public static final String DONT_CLOSE_LOKAL_BROWSER = "dontCloseLocalBrowser";
    public static final String CAPTURE_MODE_NO_DIFF = "captureModeNoDiff";
    private Properties testDataProperties;
    private static TestDataProvider instance = null;
    private static Map<Long, Properties> testPropertiesMap = new HashMap<Long, Properties>();
    private static boolean targetEnvLoadedFromMavenProperties = false;
    private static boolean execEnvLoadedFromMavenProperties = false;

    public static TestDataProvider getInstance() {
        if (instance == null) {
            instance = new TestDataProvider();
        }
        return instance;
    }

    private TestDataProvider() {
        targetEnvLoadedFromMavenProperties = !Strings.isNullOrEmpty((String)System.getProperty(TARGET_ENV));
        execEnvLoadedFromMavenProperties = !Strings.isNullOrEmpty((String)System.getProperty("env")) || !Strings.isNullOrEmpty((String)System.getProperty("exec.env"));
        this.testDataProperties = TestDataProvider.loadConfigAndSetAsSystemProperties(FOLDER_TESTCONFIG_PROPERTIES, "data.properties", false);
        this.testDataProperties.putAll((Map<?, ?>)TestDataProvider.loadConfigAndSetAsSystemProperties(FOLDER_TESTDATA_PROPERTIES, "data.properties", false));
        this.testDataProperties.putAll((Map<?, ?>)TestDataProvider.loadConfigAndSetAsSystemProperties("", FILE_ALLURETEXT_PROPERTIES, true));
        this.testDataProperties.putAll((Map<?, ?>)TestDataProvider.loadConfigAndSetAsSystemProperties(FOLDER_TESTCONFIG_PROPERTIES, FILE_ALLURETEXT_PROPERTIES, false));
    }

    public static String getTestData(String key) {
        try {
            if (TestDataProvider.getInTestDefinedProperties().containsKey(key)) {
                return TestDataProvider.getInTestDefinedProperties().get(key).toString();
            }
            return TestDataProvider.getInstance().getTestDataProperties().get(key).toString();
        }
        catch (NullPointerException e) {
            LOGGER.info("TestDataProvider.getTestData: NullPointer, key:(" + key + ") and returns \"\"");
            return "";
        }
    }

    public static boolean hasTestData(String key) {
        if (TestDataProvider.getInTestDefinedProperties().containsKey(key)) {
            return true;
        }
        return TestDataProvider.getInstance().getTestDataProperties().containsKey(key);
    }

    public static String getTestData(AllureTextEnum key) {
        try {
            return TestDataProvider.getInstance().getTestDataProperties().get(key.getValue()).toString();
        }
        catch (NullPointerException e) {
            return "";
        }
    }

    public static String getTestData(AllureTextEnum key, Object ... param) {
        try {
            return MessageFormat.format(TestDataProvider.getInstance().getTestDataProperties().get(key.getValue()).toString(), param);
        }
        catch (NullPointerException e) {
            return "";
        }
    }

    private static Properties loadConfigAndSetAsSystemProperties(String folder, String propertieFileName, boolean fromToolkit) {
        Properties props = TestDataProvider.loadConfig(folder, propertieFileName, fromToolkit);
        Iterator<Map.Entry<Object, Object>> iterator = props.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<Object, Object> o;
            Map.Entry<Object, Object> entry = o = iterator.next();
            boolean skip = false;
            if (targetEnvLoadedFromMavenProperties && (entry.getKey().toString().equals(USER_NAME) || entry.getKey().toString().equals(TARGET_ENV))) {
                skip = true;
            }
            if (execEnvLoadedFromMavenProperties && (entry.getKey().toString().equals("env") || entry.getKey().toString().equals("exec.env"))) {
                skip = true;
            }
            if (skip) continue;
            System.setProperty((String)entry.getKey(), (String)entry.getValue());
        }
        return props;
    }

    private static Properties loadConfig(String folder, String propertieFileName, boolean fromToolkit) {
        String defaultProps = folder + propertieFileName;
        Properties properties = TestDataProvider.loadProperties(defaultProps, fromToolkit);
        String targetEnvName = "";
        if (properties.contains(TARGET_ENV)) {
            targetEnvName = (String)properties.get(TARGET_ENV);
        } else if (properties.contains(USER_NAME)) {
            targetEnvName = (String)properties.get(USER_NAME);
        } else {
            targetEnvName = System.getProperties().getProperty(TARGET_ENV);
            if (Strings.isNullOrEmpty((String)targetEnvName)) {
                targetEnvName = System.getProperties().getProperty(USER_NAME);
            }
        }
        String filename = folder + targetEnvName + "." + propertieFileName;
        Properties userProperties = TestDataProvider.loadProperties(filename, fromToolkit);
        if (userProperties != null) {
            properties.putAll((Map<?, ?>)userProperties);
        }
        return properties;
    }

    private static Properties loadProperties(String name, boolean fromToolkit) {
        ClassLoader loader = fromToolkit ? TestDataProvider.class.getClassLoader() : Thread.currentThread().getContextClassLoader();
        URL url = loader.getResource(name);
        Properties props = new Properties();
        if (url != null) {
            try {
                InputStream e = url.openStream();
                props.load(e);
            }
            catch (IOException e) {
                LOGGER.error("TestDataProvider.loadProperties faild. Exception-Message:" + e.getMessage());
            }
        }
        return props;
    }

    private Properties getTestDataProperties() {
        return this.testDataProperties;
    }

    private static Properties getInTestDefinedProperties() {
        if (!testPropertiesMap.containsKey(Thread.currentThread().getId())) {
            Properties properties = new Properties();
            testPropertiesMap.put(Thread.currentThread().getId(), properties);
        }
        return testPropertiesMap.get(Thread.currentThread().getId());
    }

    public static void addInTestDefinedTestProperties(String[] properties) {
        for (String propertie : properties) {
            if (propertie.contains("=")) {
                TestDataProvider.getInTestDefinedProperties().put(propertie.substring(0, propertie.indexOf("=")), propertie.substring(propertie.indexOf("=") + 1));
                continue;
            }
            TestDataProvider.getInTestDefinedProperties().put(propertie, (Object)null);
        }
    }
}

