/*
 * Decompiled with CFR 0.152.
 */
package seleniumConsulting.ch.selenium.framework.listeners.webdriver;

import com.google.common.base.Strings;
import io.appium.java_client.events.api.general.AppiumWebDriverEventListener;
import io.qameta.allure.model.Parameter;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import javax.imageio.ImageIO;
import org.openqa.selenium.By;
import org.openqa.selenium.OutputType;
import org.openqa.selenium.TakesScreenshot;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.remote.Augmentable;
import org.openqa.selenium.remote.Augmenter;
import org.openqa.selenium.remote.ScreenshotException;
import seleniumConsulting.ch.selenium.framework.allure.AllureTextEnum;
import seleniumConsulting.ch.selenium.framework.allure.AllureUtils;
import seleniumConsulting.ch.selenium.framework.dataLoader.TestDataProvider;
import seleniumConsulting.ch.selenium.framework.driver.WebDriverManager;
import seleniumConsulting.ch.selenium.framework.listeners.webdriver.SPEED;
import seleniumConsulting.ch.selenium.framework.screenshot.utils.image.ImageProcessor;
import seleniumConsulting.ch.selenium.framework.screenshot.utils.image.model.ImageData;
import seleniumConsulting.ch.selenium.framework.screenshot.utils.web.Coordinates;

public class AppiumDriverEventListener
implements AppiumWebDriverEventListener {
    public static final String VALUE = "value";
    public static final String TYPE = "type";
    public static final String TYPE_PASSWORD = "password";
    By by;
    String oldValue = "";

    public void beforeChangeValueOf(WebElement webElement, WebDriver webDriver) {
        this.oldValue = webElement.getAttribute(TYPE_PASSWORD) != null && webElement.getAttribute(TYPE_PASSWORD).equals("true") ? Strings.repeat((String)"*", (int)webElement.getText().length()) : webElement.getText();
    }

    public void afterChangeValueOf(WebElement webElement, WebDriver webDriver) {
        if (!this.oldValue.equals(webElement.getText())) {
            String newValue = "";
            newValue = webElement.getAttribute(TYPE_PASSWORD) != null && webElement.getAttribute(TYPE_PASSWORD).equals("true") ? Strings.repeat((String)"*", (int)webElement.getText().length()) : webElement.getText();
            String message = TestDataProvider.getTestData(AllureTextEnum.ValueChange, this.oldValue, newValue);
            AllureUtils.startStep(message, new Parameter().setName("element").setValue(webElement.toString()));
            this.takeScreenshot(TestDataProvider.getTestData(AllureTextEnum.ScreenshotValueChange), webElement, message);
            SPEED.waitSpeedDuration();
            AllureUtils.stopStepPassed();
        }
        this.oldValue = "";
    }

    public void beforeAlertAccept(WebDriver webDriver) {
        System.out.println("beforeAlertAccept");
    }

    public void afterAlertAccept(WebDriver webDriver) {
        System.out.println("afterAlertAccept");
    }

    public void afterAlertDismiss(WebDriver webDriver) {
        System.out.println("afterAlertDismiss");
    }

    public void beforeAlertDismiss(WebDriver webDriver) {
        System.out.println("beforeAlertDismiss");
    }

    public void beforeNavigateTo(String s, WebDriver webDriver) {
        AllureUtils.startStep(TestDataProvider.getTestData(AllureTextEnum.GetPage, s));
    }

    public void afterNavigateTo(String s, WebDriver webDriver) {
        AllureUtils.stopStepPassed();
        SPEED.waitSpeedDuration();
    }

    public void beforeNavigateBack(WebDriver webDriver) {
        System.out.println("beforeNavigateBack");
    }

    public void afterNavigateBack(WebDriver webDriver) {
        System.out.println("afterNavigateBack");
    }

    public void beforeNavigateForward(WebDriver webDriver) {
        System.out.println("beforeNavigateForward");
    }

    public void afterNavigateForward(WebDriver webDriver) {
        System.out.println("afterNavigateForward");
    }

    public void beforeNavigateRefresh(WebDriver webDriver) {
        System.out.println("beforeNavigateRefresh");
    }

    public void afterNavigateRefresh(WebDriver webDriver) {
        System.out.println("afterNavigateRefresh");
    }

    public void beforeFindBy(By by, WebElement webElement, WebDriver webDriver) {
        this.by = by;
    }

    public void afterFindBy(By by, WebElement webElement, WebDriver webDriver) {
    }

    public void beforeClickOn(WebElement webElement, WebDriver webDriver) {
        AllureUtils.startStep(TestDataProvider.getTestData(AllureTextEnum.Click, this.by.toString()), new Parameter().setName("element").setValue(webElement.toString()));
        this.takeScreenshot(TestDataProvider.getTestData(AllureTextEnum.ScreenshotClick), webElement, this.by.toString());
        SPEED.waitSpeedDuration();
    }

    public void afterClickOn(WebElement webElement, WebDriver webDriver) {
        AllureUtils.stopStepPassed();
    }

    public void beforeChangeValueOf(WebElement webElement, WebDriver webDriver, CharSequence[] charSequences) {
        System.out.println("beforeChangeValueOf");
    }

    public void afterChangeValueOf(WebElement webElement, WebDriver webDriver, CharSequence[] charSequences) {
        System.out.println("afterChangeValueOf");
    }

    public void beforeScript(String s, WebDriver webDriver) {
        AllureUtils.startStep(TestDataProvider.getTestData(AllureTextEnum.ExecuteScript, s));
    }

    public void afterScript(String s, WebDriver webDriver) {
        AllureUtils.stopStepPassed();
    }

    public void beforeSwitchToWindow(String s, WebDriver webDriver) {
        AllureUtils.startStep(TestDataProvider.getTestData(AllureTextEnum.SwitchWindow, s));
    }

    public void afterSwitchToWindow(String s, WebDriver webDriver) {
        AllureUtils.stopStepPassed();
    }

    public void onException(Throwable throwable, WebDriver webDriver) {
    }

    public <X> void beforeGetScreenshotAs(OutputType<X> outputType) {
    }

    public <X> void afterGetScreenshotAs(OutputType<X> outputType, X x) {
    }

    public void beforeGetText(WebElement element, WebDriver driver) {
    }

    public void afterGetText(WebElement element, WebDriver driver, String text) {
    }

    private void takeScreenshot(String name, WebElement element) {
    }

    private void takeScreenshot(String name, WebElement element, String textInScreenshot) {
        try {
            TakesScreenshot takesScreenshot = (TakesScreenshot)(WebDriverManager.getWebdriver().getClass().isAnnotationPresent(Augmentable.class) ? new Augmenter().augment(WebDriverManager.getWebdriver()) : WebDriverManager.getWebdriver());
            byte[] imageByte = (byte[])takesScreenshot.getScreenshotAs(OutputType.BYTES);
            BufferedImage bi = ImageProcessor.highlight(ImageProcessor.createImageFromBytes(imageByte), new Coordinates(element, 1.0), ImageData.BLUE_BORDER_COLOR, 10);
            if (!Strings.isNullOrEmpty((String)textInScreenshot)) {
                bi = ImageProcessor.addText(bi, element.getLocation().getX(), element.getLocation().getY() - 10, textInScreenshot);
            }
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            ImageIO.write((RenderedImage)bi, "png", baos);
            AllureUtils.addPNGAttachment(name, baos.toByteArray());
        }
        catch (ScreenshotException e) {
            AllureUtils.addTextAttachment("Screenshot-Error", e.getBase64EncodedScreenshot());
            AllureUtils.addTextAttachment("Screenshot-Error-Cause", e.getMessage());
        }
        catch (IOException e) {
            AllureUtils.addTextAttachment("Screenshot-Error", e.getStackTrace().toString());
        }
    }
}

