/*
 * Decompiled with CFR 0.152.
 */
package seleniumConsulting.ch.selenium.framework.listeners.webdriver;

import com.neotys.selenium.proxies.NLWebDriver;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.events.EventFiringWebDriver;
import seleniumConsulting.ch.selenium.framework.driver.WebDriverManager;
import seleniumConsulting.ch.selenium.framework.listeners.webdriver.WebDriverEventListener;

public class NLWebDriverEventListener
extends WebDriverEventListener {
    public void beforeNavigateTo(String url, WebDriver driver) {
        super.beforeNavigateTo(url, driver);
        this.getNlDriver().startTransaction("Navigate to:" + url);
    }

    public void afterNavigateTo(String url, WebDriver driver) {
        super.afterNavigateTo(url, driver);
        this.getNlDriver().stopTransaction();
    }

    @Override
    public void beforeClickOn(WebElement element, WebDriver driver) {
        super.beforeClickOn(element, driver);
        this.getNlDriver().startTransaction("Click:" + this.getElementName(element));
    }

    @Override
    public void afterClickOn(WebElement element, WebDriver driver) {
        super.afterClickOn(element, driver);
        this.getNlDriver().stopTransaction();
    }

    private String getElementName(WebElement element) {
        return element.getAttribute("id");
    }

    public NLWebDriver getNlDriver() {
        return (NLWebDriver)((EventFiringWebDriver)WebDriverManager.getWebdriver()).getWrappedDriver();
    }
}

