/*
 * Decompiled with CFR 0.152.
 */
package seleniumConsulting.ch.selenium.framework.allure;

import io.qameta.allure.Allure;
import io.qameta.allure.model.Parameter;
import io.qameta.allure.model.Status;
import io.qameta.allure.model.StepResult;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;

public class AllureUtils {
    private static Map uuidThreadIdMap = new HashMap();

    public static void startStep(String name, Parameter value) {
        AllureUtils.startStep(name, Arrays.asList(value));
    }

    public static void startStep(String name, List<Parameter> values) {
        Allure.getLifecycle().startStep(AllureUtils.createUuid(), new StepResult().setName(name).setParameters(values));
    }

    public static void startStep(String name) {
        Allure.getLifecycle().startStep(AllureUtils.createUuid(), new StepResult().setName(name));
    }

    public static void stopStepPassed() {
        AllureUtils.stopStepWithStatus(Status.PASSED);
    }

    public static void stopStepWithStatus(Status status) {
        Allure.getLifecycle().updateStep(AllureUtils.getUuid(), s -> s.setStatus(status));
        Allure.getLifecycle().stopStep(AllureUtils.getUuid());
        AllureUtils.delUuid();
    }

    public static void logSuccess(String message) {
        AllureUtils.logInStatus(message, Status.PASSED);
    }

    @Deprecated
    public static void logInfo(String message) {
        AllureUtils.logInStatus(message, Status.PASSED);
    }

    public static void logSkipped(String message) {
        AllureUtils.logInStatus(message, Status.SKIPPED);
    }

    public static void logError(String message) {
        AllureUtils.logInStatus(message, Status.FAILED);
    }

    private static void logInStatus(String message, Status status) {
        AllureUtils.startStep(message);
        AllureUtils.stopStepWithStatus(status);
    }

    private static String getUuid() {
        return (String)uuidThreadIdMap.get((int)Thread.currentThread().getId());
    }

    private static String createUuid() {
        String uuid = UUID.randomUUID().toString();
        uuidThreadIdMap.put((int)Thread.currentThread().getId(), uuid);
        return uuid;
    }

    private static void delUuid() {
        uuidThreadIdMap.remove((int)Thread.currentThread().getId());
    }
}

