/*
 * Decompiled with CFR 0.152.
 */
package seleniumConsulting.ch.selenium.framework.database;

import io.qameta.allure.model.Parameter;
import io.qameta.allure.model.Status;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.Reader;
import java.io.StringReader;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.Arrays;
import java.util.Map;
import java.util.function.Consumer;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import seleniumConsulting.ch.selenium.framework.allure.AllureUtils;

public class DatabaseScriptExecutorNewBeta {
    private static final Logger LOGGER = LoggerFactory.getLogger(DatabaseScriptExecutorNewBeta.class);

    public static void executeSqlScript(String sqlScriptFilePath, Consumer<ResultSet> consumerOperation) {
        try {
            DatabaseScriptExecutorNewBeta.executeSqlScript(DatabaseScriptExecutorNewBeta.getReader(sqlScriptFilePath), DatabaseScriptExecutorNewBeta.getConnection(sqlScriptFilePath), consumerOperation);
            AllureUtils.stopStepPassed();
        }
        catch (Exception e) {
            LOGGER.error("Error during executeSqlScript: " + e.getMessage());
            AllureUtils.stopStepWithStatus(Status.FAILED);
        }
    }

    public static void executeSqlScriptParametrized(String sqlScriptFilePath, Map<String, String> parameters, Consumer<ResultSet> consumerOperation) throws Exception {
        DatabaseScriptExecutorNewBeta.executeSqlScript(DatabaseScriptExecutorNewBeta.getReaderParametrized(sqlScriptFilePath, parameters), DatabaseScriptExecutorNewBeta.getConnection(sqlScriptFilePath), consumerOperation);
    }

    private static Connection getConnection(String sqlScriptFilePath) throws Exception {
        String dbUser = System.getProperty("javax.persistence.jdbc.user");
        String dbPw = System.getProperty("javax.persistence.jdbc.password");
        String url = System.getProperty("javax.persistence.jdbc.url");
        String dbScriptDirectory = System.getProperty("persistence.script.dir");
        sqlScriptFilePath = dbScriptDirectory + sqlScriptFilePath;
        AllureUtils.startStep("Execute Script", Arrays.asList(new Parameter().setName("Sql-File").setValue(sqlScriptFilePath), new Parameter().setName("Url").setValue(url), new Parameter().setName("dbUser").setValue(dbUser)));
        return DriverManager.getConnection(url, dbUser, dbPw);
    }

    private static Reader getReader(String sqlScriptFilePath) throws Exception {
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        URL file = loader.getResource(sqlScriptFilePath);
        return new BufferedReader(new FileReader(file.getFile()));
    }

    private static Reader getReaderParametrized(String sqlScriptFilePath, Map<String, String> parameters) throws Exception {
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        URL file = loader.getResource(sqlScriptFilePath);
        String fileContent = new String(Files.readAllBytes(Paths.get(file.toURI())));
        for (Map.Entry<String, String> entry : parameters.entrySet()) {
            fileContent = fileContent.replaceAll(entry.getKey(), entry.getValue());
        }
        return new StringReader(fileContent);
    }

    private static void executeSqlScript(Reader reader, Connection con, Consumer<ResultSet> consumerOperation) throws Exception {
        String statementString = IOUtils.toString((Reader)reader);
        PreparedStatement preparedStatement = con.prepareStatement(statementString);
        ResultSet res = preparedStatement.executeQuery();
        consumerOperation.accept(res);
        con.close();
    }
}

