/*
 * Decompiled with CFR 0.152.
 */
package seleniumConsulting.ch.selenium.framework.driver;

import com.google.common.base.Splitter;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableMap;
import com.neotys.rest.design.client.DesignAPIClient;
import com.neotys.rest.error.NeotysAPIException;
import com.neotys.selenium.proxies.DesignManager;
import com.neotys.selenium.proxies.NLWebDriverFactory;
import com.neotys.selenium.proxies.helpers.SeleniumProxyConfig;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.security.GeneralSecurityException;
import java.util.Map;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.MutableCapabilities;
import org.openqa.selenium.Point;
import org.openqa.selenium.Proxy;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.chrome.ChromeDriver;
import org.openqa.selenium.chrome.ChromeOptions;
import org.openqa.selenium.edge.EdgeDriver;
import org.openqa.selenium.edge.EdgeOptions;
import org.openqa.selenium.firefox.FirefoxDriver;
import org.openqa.selenium.firefox.FirefoxOptions;
import org.openqa.selenium.ie.InternetExplorerDriver;
import org.openqa.selenium.ie.InternetExplorerOptions;
import org.openqa.selenium.remote.DesiredCapabilities;
import org.openqa.selenium.remote.RemoteWebDriver;
import seleniumConsulting.ch.selenium.framework.dataLoader.TestDataProvider;
import vendors.grid.TestInfo;
import vendors.grid.VendorProvider;

public class WebDriverFactory {
    public static final String REMOTE_GRID_URL = "remote.grid.url";
    public static final String CAPABILITIES = "capabilities";
    public static final String ENV = "env";
    public static final String ENV_KEY2 = "exec.env";
    public static final String WD_HUB = "/wd/hub";
    public static final String EDGE = "edge";
    public static final String CHROME_BINARY = "chromeBinary";
    public static final String NEOLOAD = "neoload";
    public static String ENV_LOCAL = "local";
    public static final String FIREFOX = "firefox";
    public static final String CHROME = "chrome";
    public static final String INTERNET_EXPLORER = "internet explorer";

    public static WebDriver createDriver(String browserName, String browserVersion, Map<String, String> capibilitiesMetadata, TestInfo testInfo) {
        FirefoxDriver driver;
        String env = System.getProperty(ENV);
        if (Strings.isNullOrEmpty((String)env)) {
            env = System.getProperty(ENV_KEY2);
        }
        if (ENV_LOCAL.equalsIgnoreCase(env)) {
            switch (browserName) {
                case "firefox": {
                    FirefoxOptions firefoxOptions = new FirefoxOptions();
                    firefoxOptions.setCapability("acceptInsecureCerts", true);
                    firefoxOptions.setCapability("marionette", true);
                    firefoxOptions = (FirefoxOptions)WebDriverFactory.addNeoloadCapIfNeeded((MutableCapabilities)firefoxOptions);
                    driver = new FirefoxDriver(firefoxOptions);
                    break;
                }
                case "chrome": {
                    ChromeOptions chromeOptions = new ChromeOptions();
                    chromeOptions.setExperimentalOption("useAutomationExtension", (Object)false);
                    if (!Strings.isNullOrEmpty((String)TestDataProvider.getTestData(CHROME_BINARY))) {
                        chromeOptions.setBinary(TestDataProvider.getTestData(CHROME_BINARY));
                    }
                    chromeOptions = (ChromeOptions)WebDriverFactory.addNeoloadCapIfNeeded((MutableCapabilities)chromeOptions);
                    driver = new ChromeDriver(chromeOptions);
                    break;
                }
                case "internet explorer": {
                    DesiredCapabilities desiredCapabilities = DesiredCapabilities.internetExplorer();
                    desiredCapabilities.setCapability("ignoreProtectedModeSettings", true);
                    desiredCapabilities.setCapability("ignoreZoomSetting", true);
                    desiredCapabilities.setCapability("elementScrollBehavior", (Object)1);
                    desiredCapabilities.setCapability("nativeEvents", false);
                    desiredCapabilities = (DesiredCapabilities)WebDriverFactory.addNeoloadCapIfNeeded((MutableCapabilities)desiredCapabilities);
                    InternetExplorerOptions internetExplorerOptions = new InternetExplorerOptions((Capabilities)desiredCapabilities);
                    driver = new InternetExplorerDriver(internetExplorerOptions);
                    break;
                }
                case "edge": {
                    DesiredCapabilities desiredCapabilitiesEdge = DesiredCapabilities.edge();
                    desiredCapabilitiesEdge.setCapability("ignoreProtectedModeSettings", true);
                    desiredCapabilitiesEdge = (DesiredCapabilities)WebDriverFactory.addNeoloadCapIfNeeded((MutableCapabilities)desiredCapabilitiesEdge);
                    EdgeOptions edgeOptions = new EdgeOptions();
                    edgeOptions.merge((Capabilities)desiredCapabilitiesEdge);
                    driver = new EdgeDriver(edgeOptions);
                    break;
                }
                default: {
                    throw new RuntimeException("Browser " + browserName + " is not available on local platform ");
                }
            }
            if (TestDataProvider.hasTestData(NEOLOAD)) {
                String purePath = Strings.isNullOrEmpty((String)testInfo.getNlPurePath()) ? testInfo.getTestname() : testInfo.getNlPurePath();
                driver = NLWebDriverFactory.newNLWebDriver((WebDriver)driver, (String)purePath, null);
            }
        } else {
            ChromeOptions options;
            switch (browserName) {
                case "chrome": {
                    options = new ChromeOptions();
                    break;
                }
                case "firefox": {
                    options = new FirefoxOptions();
                    break;
                }
                case "edge": {
                    options = new EdgeOptions();
                    break;
                }
                case "internet explorer": {
                    options = new InternetExplorerOptions();
                    break;
                }
                default: {
                    throw new RuntimeException("Browser " + browserName + " is not supported in the Selenium toolkit");
                }
            }
            if (!Strings.isNullOrEmpty((String)browserVersion)) {
                options.setCapability("browserVersion", browserVersion);
            }
            options.setCapability("acceptInsecureCerts", true);
            VendorProvider.getVendor().addCapibilities(testInfo, (MutableCapabilities)options);
            WebDriverFactory.setConfigCapibilities((MutableCapabilities)options);
            WebDriverFactory.setWebTestAnnotationCapibilities((MutableCapabilities)options, capibilitiesMetadata);
            driver = WebDriverFactory.createRemoteDriver(System.getProperty(REMOTE_GRID_URL) + WD_HUB, (MutableCapabilities)options);
        }
        System.out.println(((RemoteWebDriver)driver).getCapabilities().toString());
        WebDriverFactory.setWindowSizeFullscreen((WebDriver)driver);
        return driver;
    }

    public static MutableCapabilities addNeoloadCapIfNeeded(MutableCapabilities mutableCapabilities) {
        if (TestDataProvider.hasTestData(NEOLOAD)) {
            int port;
            System.setProperty("nl.selenium.proxy.mode", "Design");
            DesignAPIClient designAPIClient = DesignManager.getDesignApiClient();
            String host = WebDriverFactory.getDomainName(SeleniumProxyConfig.getDesignAPIURL());
            try {
                port = designAPIClient.getRecorderSettings().getProxySettings().getPort();
            }
            catch (NeotysAPIException | IOException | URISyntaxException | GeneralSecurityException e) {
                e.printStackTrace();
                throw new RuntimeException(e);
            }
            String proxyString = host + ":" + port;
            Proxy proxy = new Proxy();
            proxy.setProxyType(Proxy.ProxyType.MANUAL);
            proxy.setHttpProxy(proxyString);
            proxy.setSslProxy(proxyString);
            mutableCapabilities.setCapability("proxy", (Object)proxy);
            mutableCapabilities.setCapability("acceptSslCert", true);
        }
        return mutableCapabilities;
    }

    private static String getDomainName(String url) {
        try {
            URI uri = new URI(url);
            String domain = uri.getHost();
            return domain.startsWith("www.") ? domain.substring(4) : domain;
        }
        catch (URISyntaxException e) {
            e.printStackTrace();
            return "localhost";
        }
    }

    private static void setWebTestAnnotationCapibilities(MutableCapabilities capabilities, Map<String, String> capibilitiesMetadata) {
        if (capibilitiesMetadata != null && !capibilitiesMetadata.isEmpty()) {
            capibilitiesMetadata.forEach((key, value) -> {
                if (value.equals("true") || value.equals("false")) {
                    capabilities.setCapability(key, Boolean.parseBoolean(value));
                } else {
                    capabilities.setCapability(key, value);
                }
            });
        }
    }

    private static void setConfigCapibilities(MutableCapabilities capabilities) {
        if (!Strings.isNullOrEmpty((String)TestDataProvider.getTestData(CAPABILITIES))) {
            ImmutableMap map = ImmutableMap.copyOf((Map)Splitter.on((String)",").withKeyValueSeparator("=").split((CharSequence)TestDataProvider.getTestData(CAPABILITIES)));
            map.forEach((key, value) -> {
                if (value.equals("true") || value.equals("false")) {
                    capabilities.setCapability(key, Boolean.parseBoolean(value));
                } else {
                    capabilities.setCapability(key, value);
                }
            });
        }
    }

    private static RemoteWebDriver createRemoteDriver(String url, MutableCapabilities desiredCapabilities) {
        try {
            return new RemoteWebDriver(new URL(url), (Capabilities)desiredCapabilities);
        }
        catch (MalformedURLException e) {
            throw new RuntimeException("Unable to create Remotewebdriver for grid url:" + url + " message:" + e.getMessage());
        }
    }

    private static void setWindowSizeFullscreen(WebDriver driver) {
        driver.manage().window().setPosition(new Point(0, 0));
        driver.manage().window().maximize();
    }
}

