/*
 * Decompiled with CFR 0.152.
 */
package seleniumConsulting.ch.selenium.framework.listeners.webdriver;

import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import seleniumConsulting.ch.selenium.framework.driver.WebDriverManager;
import seleniumConsulting.ch.selenium.framework.driver.neoload.NeoLoadTransactionManager;
import seleniumConsulting.ch.selenium.framework.driver.neoload.Transaction;
import seleniumConsulting.ch.selenium.framework.listeners.webdriver.WebDriverEventListener;

public class NLWebDriverEventListener
extends WebDriverEventListener {
    @Override
    public void beforeNavigateTo(String url, WebDriver driver) {
        super.beforeNavigateTo(url, driver);
        this.startIfNoManuelStarted("Navigate to:" + url);
    }

    @Override
    public void afterNavigateTo(String url, WebDriver driver) {
        super.afterNavigateTo(url, driver);
        this.stopIfNoManuelStarted();
    }

    @Override
    public void beforeClickOn(WebElement element, WebDriver driver) {
        super.beforeClickOn(element, driver);
        this.startIfNoManuelStarted("Click:" + this.getElementName(element));
    }

    @Override
    public void afterClickOn(WebElement element, WebDriver driver) {
        super.afterClickOn(element, driver);
        this.stopIfNoManuelStarted();
    }

    private String getElementName(WebElement element) {
        return element.getAttribute("id");
    }

    private void startIfNoManuelStarted(String name) {
        if (NeoLoadTransactionManager.getTransaction() == null || !NeoLoadTransactionManager.getTransaction().equals((Object)Transaction.MANUEL)) {
            NeoLoadTransactionManager.setTransaction(Transaction.AUTO);
            WebDriverManager.getNlDriver().startTransaction(name);
        }
    }

    private void stopIfNoManuelStarted() {
        if (NeoLoadTransactionManager.getTransaction() != null && !NeoLoadTransactionManager.getTransaction().equals((Object)Transaction.MANUEL)) {
            NeoLoadTransactionManager.delTransaction();
            WebDriverManager.getNlDriver().stopTransaction();
        }
    }
}

