/*
 * Decompiled with CFR 0.152.
 */
package seleniumConsulting.ch.selenium.framework.listeners.webdriver;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum SPEED {
    NORMAL(0),
    SLOW(1000),
    VERY_SLOW(3000);

    private static final Logger LOGGER;
    private static final String CONF_NAME = "speedMode";
    int waitDuration;

    private SPEED(int waitDuration) {
        this.waitDuration = waitDuration;
    }

    public int getWaitDuration() {
        return this.waitDuration;
    }

    public static long getWaitDurationOfConfSpeed() {
        long speed;
        try {
            speed = SPEED.valueOf(System.getProperty(CONF_NAME)).getWaitDuration();
        }
        catch (Exception e) {
            speed = NORMAL.getWaitDuration();
        }
        return speed;
    }

    public static void waitSpeedDuration() {
        try {
            Thread.sleep(SPEED.getWaitDurationOfConfSpeed());
        }
        catch (InterruptedException e) {
            LOGGER.error("Speed.wait Error ", (Throwable)e);
        }
    }

    static {
        LOGGER = LoggerFactory.getLogger(SPEED.class);
    }
}

