/*
 * Decompiled with CFR 0.152.
 */
package seleniumConsulting.ch.selenium.framework.listeners.webdriver;

import io.qameta.allure.Attachment;
import io.qameta.allure.model.Parameter;
import java.util.Arrays;
import org.openqa.selenium.By;
import org.openqa.selenium.JavascriptExecutor;
import org.openqa.selenium.Keys;
import org.openqa.selenium.OutputType;
import org.openqa.selenium.TakesScreenshot;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.remote.Augmentable;
import org.openqa.selenium.remote.Augmenter;
import org.openqa.selenium.support.events.AbstractWebDriverEventListener;
import seleniumConsulting.ch.selenium.framework.allure.AllureTextEnum;
import seleniumConsulting.ch.selenium.framework.allure.AllureUtils;
import seleniumConsulting.ch.selenium.framework.dataLoader.TestDataProvider;
import seleniumConsulting.ch.selenium.framework.driver.WebDriverManager;
import seleniumConsulting.ch.selenium.framework.listeners.webdriver.SPEED;

public class WebDriverEventListener
extends AbstractWebDriverEventListener {
    public static final String VALUE = "value";
    public static final String TYPE = "type";
    public static final String TYPE_PASSWORD = "password";
    By by;
    String message = "";

    public void beforeNavigateTo(String url, WebDriver driver) {
        AllureUtils.startStep(TestDataProvider.getTestData(AllureTextEnum.GetPage, url));
    }

    public void afterNavigateTo(String url, WebDriver driver) {
        AllureUtils.stopStepPassed();
        SPEED.waitSpeedDuration();
    }

    public void beforeClickOn(WebElement element, WebDriver driver) {
        AllureUtils.startStep(TestDataProvider.getTestData(AllureTextEnum.Click, this.by.toString()), new Parameter().setName("element").setValue(element.toString()));
        this.addHighlightElement(element, "Click");
        this.takeScreenshot(TestDataProvider.getTestData(AllureTextEnum.ScreenshotClick));
        SPEED.waitSpeedDuration();
        this.removeHighlightElement();
    }

    public void afterClickOn(WebElement element, WebDriver driver) {
        AllureUtils.stopStepPassed();
    }

    public void beforeFindBy(By by, WebElement element, WebDriver driver) {
        this.by = by;
    }

    public void beforeChangeValueOf(WebElement element, WebDriver driver, CharSequence[] keysToSend) {
        if (element.getTagName().equalsIgnoreCase("input")) {
            String oldValue = element.getAttribute(VALUE);
            if (keysToSend[0].equals(Keys.chord((CharSequence[])new CharSequence[]{Keys.CONTROL, "a"}))) {
                keysToSend = Arrays.copyOfRange(keysToSend, 1, keysToSend.length);
            }
            String newValue = Arrays.toString(keysToSend);
            if (keysToSend.length == 1) {
                newValue = keysToSend[0].toString();
            }
            if (element.getAttribute(TYPE).equals(TYPE_PASSWORD)) {
                oldValue = "**********";
                newValue = "**********";
            }
            this.message = TestDataProvider.getTestData(AllureTextEnum.ValueChange, oldValue, newValue);
            AllureUtils.startStep(this.message, new Parameter().setName("element").setValue(element.toString()));
        } else {
            this.message = TestDataProvider.getTestData(AllureTextEnum.SendKeys, keysToSend);
            AllureUtils.startStep(this.message, new Parameter().setName("element").setValue(element.toString()));
        }
    }

    public void afterChangeValueOf(WebElement element, WebDriver driver, CharSequence[] keysToSend) {
        this.addHighlightElement(element, this.message);
        this.takeScreenshot(TestDataProvider.getTestData(AllureTextEnum.ScreenshotValueChange));
        SPEED.waitSpeedDuration();
        this.removeHighlightElement();
        AllureUtils.stopStepPassed();
        this.message = "";
    }

    private void addHighlightElement(WebElement element, String message) {
        ((JavascriptExecutor)WebDriverManager.getWebdriver()).executeScript("var node = document.createElement(\"div\");\nvar childnode = document.createElement(\"div\");\nvar textnode = document.createElement(\"span\");\nnode.setAttribute('id','seleniumHighlight');\nnode.style.cssText = 'position: absolute;z-index: 100000;width: '+arguments[2]+'px;top:'+arguments[1]+'px;left: '+arguments[0]+'px';\ntextnode.style.cssText = 'white-space: nowrap;background: rgba(81, 203, 238, 1) !important';\nchildnode.style.cssText = 'box-shadow: 0 0 20px rgba(81, 203, 238, 0.5) !important;height: '+arguments[3]+'px;border: 3px solid rgba(81, 203, 238, 0.5) !important;background: rgba(81, 203, 238, 0.5) !important;'\ntextnode.textContent = arguments[5]+arguments[4];\nnode.appendChild(textnode);\nnode.appendChild(childnode);\ndocument.body.appendChild(node);", new Object[]{element.getLocation().x - 10, element.getLocation().y - 12, element.getSize().width + 20, element.getSize().height + 10, this.by.toString(), message.isEmpty() ? "" : message + ": "});
    }

    private void removeHighlightElement() {
        ((JavascriptExecutor)WebDriverManager.getWebdriver()).executeScript("document.getElementById('seleniumHighlight') != undefined ? document.getElementById('seleniumHighlight').parentNode.removeChild(document.getElementById('seleniumHighlight')) : ''", new Object[0]);
    }

    @Attachment(value="{message}", type="image/png")
    private byte[] takeScreenshot(String message) {
        TakesScreenshot takesScreenshot = (TakesScreenshot)(WebDriverManager.getWebdriver().getClass().isAnnotationPresent(Augmentable.class) ? new Augmenter().augment(WebDriverManager.getWebdriver()) : WebDriverManager.getWebdriver());
        return (byte[])takesScreenshot.getScreenshotAs(OutputType.BYTES);
    }
}

