/*
 * Decompiled with CFR 0.152.
 */
package seleniumConsulting.ch.selenium.framework.screenshot.core;

import org.openqa.selenium.WebElement;
import seleniumConsulting.ch.selenium.framework.screenshot.core.Capture;
import seleniumConsulting.ch.selenium.framework.screenshot.core.ElementSnapshot;
import seleniumConsulting.ch.selenium.framework.screenshot.utils.web.Browser;

public class ShootElement {
    public ElementSnapshot shoot(WebElement element) {
        return this.shoot(element, true);
    }

    public ElementSnapshot shoot(WebElement element, Capture capture) {
        return this.shoot(element, capture, true);
    }

    public ElementSnapshot shoot(WebElement element, boolean useDevicePixelRatio) {
        Browser browser = new Browser(useDevicePixelRatio);
        ElementSnapshot elementSnapshot = new ElementSnapshot(browser.getDevicePixelRatio());
        browser.scrollToElement(element);
        elementSnapshot.setImage(browser.takeScreenshot(), browser.getCoordinates(element));
        return elementSnapshot;
    }

    public ElementSnapshot shoot(WebElement element, Capture capture, boolean useDevicePixelRatio) {
        return this.shoot(element, capture, useDevicePixelRatio, 100);
    }

    public ElementSnapshot shoot(WebElement element, Capture capture, int waitBeforeScreeshot) {
        return this.shoot(element, capture, true, waitBeforeScreeshot);
    }

    public ElementSnapshot shoot(WebElement element, Capture capture, boolean useDevicePixelRatio, int waitBeforeScreeshot) {
        Browser browser = new Browser(useDevicePixelRatio, waitBeforeScreeshot);
        ElementSnapshot elementSnapshot = new ElementSnapshot(browser.getDevicePixelRatio());
        browser.scrollToElement(element);
        switch (capture) {
            case VERTICAL_SCROLL: {
                elementSnapshot.setImage(browser.takeFullElementVerticalScreenshotScroll(element));
                break;
            }
            case HORIZONTAL_SCROLL: {
                elementSnapshot.setImage(browser.takeFullElementHorizontalScreenshotScroll(element));
                break;
            }
            case FULL_SCROLL: {
                elementSnapshot.setImage(browser.takeFullElementScreenshotScroll(element));
                break;
            }
            default: {
                elementSnapshot.setImage(browser.takeElementViewportScreenshot(element));
            }
        }
        return elementSnapshot;
    }
}

