/*
 * Decompiled with CFR 0.152.
 */
package seleniumConsulting.ch.selenium.framework.screenshot.core;

import io.qameta.allure.model.Status;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.imageio.ImageIO;
import seleniumConsulting.ch.selenium.framework.allure.AllureTextEnum;
import seleniumConsulting.ch.selenium.framework.allure.AllureUtils;
import seleniumConsulting.ch.selenium.framework.dataLoader.TestDataProvider;
import seleniumConsulting.ch.selenium.framework.screenshot.utils.file.FileUtil;
import seleniumConsulting.ch.selenium.framework.screenshot.utils.image.ImageProcessor;

public abstract class Snapshot<T extends Snapshot> {
    private static final String EXTENSION = "PNG";
    protected static final String ELEMENT_OUT_OF_VIEWPORT_EX_MESSAGE = "Requested element is outside the viewport";
    protected static final Color COLOR = new Color(81, 203, 238, 128);
    private String fileName = new SimpleDateFormat("yyyy_MM_dd_HH_mm_ss_SSS").format(new Date()) + "." + "PNG".toLowerCase();
    private Path location = Paths.get("./screenshots/", new String[0]);
    private String title;
    protected BufferedImage image;
    protected Double devicePixelRatio = 1.0;

    protected abstract T self();

    public T withName(String name) {
        if (name != null) {
            this.fileName = name + "." + EXTENSION.toLowerCase();
        }
        return this.self();
    }

    public T withTitle(String title) {
        this.title = title;
        return this.self();
    }

    private File getFile(String path, String name) {
        File thumbnailFile = new File(path, name);
        if (!Files.exists(Paths.get(path, new String[0]), new LinkOption[0])) {
            thumbnailFile.mkdirs();
        }
        return thumbnailFile;
    }

    public T monochrome() {
        this.image = ImageProcessor.convertToGrayAndWhite(this.image);
        return this.self();
    }

    public BufferedImage getImage() {
        return this.image;
    }

    public byte[] getBytes() throws IOException {
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        ImageIO.write((RenderedImage)this.image, "png", outputStream);
        return outputStream.toByteArray();
    }

    protected void setImage(BufferedImage image) {
        ((Snapshot)this.self()).image = image;
    }

    public void save() {
        AllureUtils.startStep("Screenshot");
        File screenshotFile = new File(this.location.toString(), this.fileName);
        if (!Files.exists(this.location, new LinkOption[0])) {
            screenshotFile.mkdirs();
        }
        if (this.title != null && !this.title.isEmpty()) {
            this.image = ImageProcessor.addTitle(this.image, this.title, Color.red, new Font("Serif", 1, 20));
        }
        BufferedImage output = new BufferedImage(this.image.getWidth(), this.image.getHeight(), 1);
        Graphics2D graphics2D = output.createGraphics();
        graphics2D.drawImage((Image)this.image, 0, 0, null);
        FileUtil.writeImage(output, EXTENSION, screenshotFile);
        AllureUtils.stopStepPassed();
    }

    public void save(String path) {
        this.location = Paths.get(path, new String[0]);
        this.save();
    }

    public boolean equalsWithDiff(String reverenceImagePath, String resultingImagePath) {
        return this.equalsWithDiff(reverenceImagePath, resultingImagePath, 0.0);
    }

    public boolean equalsWithDiff(String reverenceImagePath, String resultingImagePath, double deviation) {
        if (TestDataProvider.hasTestData("captureModeNoDiff")) {
            AllureUtils.startStep(AllureTextEnum.ScreenshotRevCapture);
            FileUtil.writeImage(this.getImage(), "png", reverenceImagePath);
            AllureUtils.stopStepPassed();
            return true;
        }
        AllureUtils.startStep(AllureTextEnum.ScreenShotEquals);
        BufferedImage image = FileUtil.getImage(reverenceImagePath);
        if (this.getImage() == image) {
            AllureUtils.stopStepPassed();
            return true;
        }
        Boolean res = this.getImage() != null ? ImageProcessor.imagesAreEqualsWithDiff(this.getImage(), image, resultingImagePath, deviation) : image == null;
        if (res.booleanValue()) {
            AllureUtils.stopStepPassed();
        } else {
            AllureUtils.stopStepWithStatus(Status.FAILED);
        }
        return res;
    }

    public int hashCode() {
        return this.getImage() != null ? this.getImage().hashCode() : 0;
    }
}

