/*
 * Decompiled with CFR 0.152.
 */
package seleniumConsulting.ch.selenium.framework.allure;

import io.qameta.allure.Allure;
import io.qameta.allure.model.Parameter;
import io.qameta.allure.model.Status;
import io.qameta.allure.model.StepResult;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import seleniumConsulting.ch.selenium.framework.allure.AllureTextEnum;
import seleniumConsulting.ch.selenium.framework.dataLoader.TestDataProvider;

public class AllureUtils {
    private static Map<Long, LinkedList> uuidThreadIdMap = new HashMap<Long, LinkedList>();
    private static Map<Long, Boolean> testHasScreenshotDiffError = new HashMap<Long, Boolean>();

    public static void startStep(String name) {
        Allure.getLifecycle().startStep(AllureUtils.createUuid(), new StepResult().setName(name));
    }

    public static void startStep(String name, Parameter value) {
        AllureUtils.startStep(name, Arrays.asList(value));
    }

    public static void startStep(String name, List<Parameter> values) {
        Allure.getLifecycle().startStep(AllureUtils.createUuid(), new StepResult().setName(name).setParameters(values));
    }

    public static void startStep(AllureTextEnum allureTextEnum) {
        Allure.getLifecycle().startStep(AllureUtils.createUuid(), new StepResult().setName(TestDataProvider.getTestData(allureTextEnum)));
    }

    public static void startStep(AllureTextEnum allureTextEnum, Parameter value) {
        AllureUtils.startStep(allureTextEnum, Arrays.asList(value));
    }

    public static void startStep(AllureTextEnum allureTextEnum, List<Parameter> values) {
        Allure.getLifecycle().startStep(AllureUtils.createUuid(), new StepResult().setName(TestDataProvider.getTestData(allureTextEnum)).setParameters(values));
    }

    public static void stopStepPassed() {
        AllureUtils.stopStepWithStatus(Status.PASSED);
    }

    public static void stopStepWithStatus(Status status) {
        Allure.getLifecycle().updateStep(AllureUtils.getUuid(), s -> s.setStatus(status));
        Allure.getLifecycle().stopStep(AllureUtils.getUuid());
        AllureUtils.delUuid();
    }

    public static void logSuccess(String message) {
        AllureUtils.logInStatus(message, Status.PASSED);
    }

    @Deprecated
    public static void logInfo(String message) {
        AllureUtils.logInStatus(message, Status.PASSED);
    }

    public static void logSkipped(String message) {
        AllureUtils.logInStatus(message, Status.SKIPPED);
    }

    public static void logError(String message) {
        AllureUtils.logInStatus(message, Status.FAILED);
    }

    public static void addPngAttachment(String name, byte[] body) {
        Allure.getLifecycle().addAttachment(name, "image/png", "png", body);
    }

    public static void addAttachment(String name, String type, String fileExtension, byte[] body) {
        Allure.getLifecycle().addAttachment(name, type, fileExtension, body);
    }

    public static void addPNGAttachment(String name, byte[] body) {
        AllureUtils.addAttachment(name, "image/png", "png", body);
    }

    public static void addTextAttachment(String name, String body) {
        AllureUtils.addAttachment(name, "text/plain", "txt", body.getBytes());
    }

    public static void setTestHasScreenshotDiffError(boolean diffError) {
        testHasScreenshotDiffError.put(Thread.currentThread().getId(), diffError);
    }

    public static boolean getTestHasScreenshotDiffError() {
        if (testHasScreenshotDiffError.containsKey(Thread.currentThread().getId())) {
            return testHasScreenshotDiffError.get(Thread.currentThread().getId());
        }
        return false;
    }

    private static void logInStatus(String message, Status status) {
        AllureUtils.startStep(message);
        AllureUtils.stopStepWithStatus(status);
    }

    private static String getUuid() {
        return (String)uuidThreadIdMap.get(Thread.currentThread().getId()).getLast();
    }

    private static String createUuid() {
        String uuid = UUID.randomUUID().toString();
        if (!uuidThreadIdMap.containsKey(Thread.currentThread().getId())) {
            uuidThreadIdMap.put(Thread.currentThread().getId(), new LinkedList());
        }
        uuidThreadIdMap.get(Thread.currentThread().getId()).push(uuid);
        return uuid;
    }

    private static void delUuid() {
        uuidThreadIdMap.get(Thread.currentThread().getId()).removeLast();
        if (uuidThreadIdMap.get(Thread.currentThread().getId()).isEmpty()) {
            uuidThreadIdMap.remove(Thread.currentThread().getId());
        }
    }
}

