/*
 * Decompiled with CFR 0.152.
 */
package seleniumConsulting.ch.selenium.framework.screenshot.core;

import java.awt.Color;
import java.awt.Font;
import java.awt.image.RasterFormatException;
import org.openqa.selenium.WebElement;
import seleniumConsulting.ch.selenium.framework.screenshot.core.Snapshot;
import seleniumConsulting.ch.selenium.framework.screenshot.utils.image.ImageProcessor;
import seleniumConsulting.ch.selenium.framework.screenshot.utils.image.model.ImageData;
import seleniumConsulting.ch.selenium.framework.screenshot.utils.web.Coordinates;
import seleniumConsulting.ch.selenium.framework.screenshot.utils.web.ElementOutsideViewportException;

public class PageSnapshot
extends Snapshot {
    PageSnapshot(Double devicePixelRatio) {
        this.devicePixelRatio = devicePixelRatio;
    }

    public PageSnapshot highlight(WebElement element) {
        try {
            this.highlight(element, ImageData.BLUE_BORDER_COLOR, 3);
        }
        catch (RasterFormatException rfe) {
            throw new ElementOutsideViewportException("Requested element is outside the viewport", rfe);
        }
        return this;
    }

    public PageSnapshot highlight(WebElement element, Color color, int lineWidth) {
        try {
            this.image = ImageProcessor.highlight(this.image, new Coordinates(element, this.devicePixelRatio), color, lineWidth);
        }
        catch (RasterFormatException rfe) {
            throw new ElementOutsideViewportException("Requested element is outside the viewport", rfe);
        }
        return this;
    }

    public PageSnapshot highlightWithText(WebElement element, String text) {
        try {
            this.highlightWithText(element, ImageData.BLUE_BORDER_COLOR, text, new Font("Serif", 1, 20));
        }
        catch (RasterFormatException rfe) {
            throw new ElementOutsideViewportException("Requested element is outside the viewport", rfe);
        }
        return this;
    }

    public PageSnapshot highlightWithText(WebElement element, Color color, String text, Font textFont) {
        try {
            this.highlight(element, color, 0);
            Coordinates coords = new Coordinates(element, this.devicePixelRatio);
            this.image = ImageProcessor.addText(this.image, coords.getX(), coords.getY() - textFont.getSize() / 2, text, color, textFont);
        }
        catch (RasterFormatException rfe) {
            throw new ElementOutsideViewportException("Requested element is outside the viewport", rfe);
        }
        return this;
    }

    public PageSnapshot cropAround(WebElement element, int offsetX, int offsetY) {
        try {
            this.image = ImageProcessor.cropAround(this.image, new Coordinates(element, this.devicePixelRatio), offsetX, offsetY);
        }
        catch (RasterFormatException rfe) {
            throw new ElementOutsideViewportException("Requested element is outside the viewport", rfe);
        }
        return this;
    }

    public PageSnapshot cutOut(int offsetX, int offsetY, WebElement ... elements) {
        try {
            for (WebElement element : elements) {
                ImageProcessor.cutOut(this.image, new Coordinates(element, this.devicePixelRatio), offsetX, offsetY);
            }
        }
        catch (RasterFormatException rfe) {
            throw new ElementOutsideViewportException("Requested element is outside the viewport", rfe);
        }
        return this;
    }

    public PageSnapshot cutOut(WebElement ... elements) {
        try {
            for (WebElement element : elements) {
                ImageProcessor.cutOut(this.image, new Coordinates(element, this.devicePixelRatio), 0, 0);
            }
        }
        catch (RasterFormatException rfe) {
            throw new ElementOutsideViewportException("Requested element is outside the viewport", rfe);
        }
        return this;
    }

    protected PageSnapshot self() {
        return this;
    }
}

