/*
 * Decompiled with CFR 0.152.
 */
package seleniumConsulting.ch.selenium.framework.screenshot.core;

import org.openqa.selenium.By;
import org.openqa.selenium.WebElement;
import seleniumConsulting.ch.selenium.framework.driver.WebDriverManager;
import seleniumConsulting.ch.selenium.framework.screenshot.core.Capture;
import seleniumConsulting.ch.selenium.framework.screenshot.core.PageSnapshot;
import seleniumConsulting.ch.selenium.framework.screenshot.utils.web.Browser;
import seleniumConsulting.ch.selenium.framework.screenshot.utils.web.Coordinates;

public class ShootFrame {
    public PageSnapshot shoot(WebElement frame, Capture capture) {
        return this.shoot(frame, capture, true, 100);
    }

    public PageSnapshot shoot(WebElement frame, Capture capture, int waitBeforeScreeshot) {
        return this.shoot(frame, capture, true, waitBeforeScreeshot);
    }

    public PageSnapshot shoot(String frameId, Capture capture, boolean useDevicePixelRatio) {
        return this.shoot(frameId, capture, useDevicePixelRatio, 100);
    }

    public PageSnapshot shoot(String frameId, Capture capture, int waitBeforeScreeshot) {
        return this.shoot(frameId, capture, true, waitBeforeScreeshot);
    }

    public PageSnapshot shoot(String frameId) {
        return this.shoot(frameId, Capture.VIEWPORT, true, 100);
    }

    public PageSnapshot shoot(String frameId, Capture capture, boolean useDevicePixelRatio, int waitBeforeScreeshot) {
        return this.shoot(WebDriverManager.getWebdriver().findElement(By.id((String)frameId)), capture, useDevicePixelRatio, waitBeforeScreeshot);
    }

    public PageSnapshot shoot(WebElement frame, Capture capture, boolean useDevicePixelRatio, int waitBeforeScreeshot) {
        Browser browser = new Browser(useDevicePixelRatio, waitBeforeScreeshot);
        browser.scrollToElement(frame);
        Coordinates coordinates = browser.getCoordinates(frame);
        Browser browserParent = new Browser(useDevicePixelRatio);
        if (capture != Capture.VIEWPORT && (coordinates.getWidth() > browserParent.getViewportWidth() || coordinates.getHeight() > browserParent.getViewportHeight())) {
            throw new UnsupportedOperationException("Full frame screenshot is only available if WHOLE frame is fully visible in the viewport. Use Capture.VIEWPORT in case frame is outside of visible viewport.");
        }
        WebDriverManager.getWebdriver().switchTo().frame(frame);
        PageSnapshot pageScreenshot = new PageSnapshot(browser.getDevicePixelRatio());
        switch (capture) {
            case VERTICAL_SCROLL: {
                pageScreenshot.setImage(browser.takeFullPageVerticalScreenshotScroll(coordinates));
                break;
            }
            case HORIZONTAL_SCROLL: {
                pageScreenshot.setImage(browser.takeFullPageHorizontalScreenshotScroll(coordinates));
                break;
            }
            case FULL_SCROLL: {
                pageScreenshot.setImage(browser.takeFullPageScreenshotScroll(coordinates));
                break;
            }
            default: {
                pageScreenshot.setImage(browser.takeFrameViewportScreenshot(coordinates));
            }
        }
        WebDriverManager.getWebdriver().switchTo().parentFrame();
        return pageScreenshot;
    }
}

