/*
 * Decompiled with CFR 0.152.
 */
package seleniumConsulting.ch.selenium.framework.screenshot.core;

import seleniumConsulting.ch.selenium.framework.screenshot.core.Capture;
import seleniumConsulting.ch.selenium.framework.screenshot.core.PageSnapshot;
import seleniumConsulting.ch.selenium.framework.screenshot.utils.web.Browser;

public class ShootPage {
    public PageSnapshot shoot() {
        return this.shoot(true);
    }

    public PageSnapshot shoot(boolean useDevicePixelRatio) {
        Browser browser = new Browser(useDevicePixelRatio);
        PageSnapshot pageScreenshot = new PageSnapshot(browser.getDevicePixelRatio());
        pageScreenshot.setImage(browser.takeScreenshot());
        return pageScreenshot;
    }

    public PageSnapshot shoot(Capture capture) {
        return this.shoot(capture, true);
    }

    public PageSnapshot shoot(Capture capture, boolean useDevicePixelRatio) {
        return this.shoot(capture, useDevicePixelRatio, 100);
    }

    public PageSnapshot shoot(Capture capture, int waitBeforeScreeshot) {
        return this.shoot(capture, true, waitBeforeScreeshot);
    }

    public PageSnapshot shoot(Capture capture, boolean useDevicePixelRatio, int waitBeforeScreeshot) {
        Browser browser = new Browser(useDevicePixelRatio, waitBeforeScreeshot);
        PageSnapshot pageScreenshot = new PageSnapshot(browser.getDevicePixelRatio());
        switch (capture) {
            case VIEWPORT: {
                pageScreenshot.setImage(browser.takeScreenshot());
                break;
            }
            case VERTICAL_SCROLL: {
                pageScreenshot.setImage(browser.takeFullPageVerticalScreenshotScroll(null));
                break;
            }
            case HORIZONTAL_SCROLL: {
                pageScreenshot.setImage(browser.takeFullPageHorizontalScreenshotScroll(null));
                break;
            }
            case FULL_SCROLL: {
                pageScreenshot.setImage(browser.takeFullPageScreenshotScroll(null));
            }
        }
        return pageScreenshot;
    }
}

