/*
 * Decompiled with CFR 0.152.
 */
package seleniumConsulting.ch.selenium.framework.screenshot.utils.file;

import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import javax.imageio.ImageIO;
import org.apache.commons.io.IOUtils;
import seleniumConsulting.ch.selenium.framework.allure.AllureUtils;
import seleniumConsulting.ch.selenium.framework.screenshot.utils.file.UnableGetImageException;
import seleniumConsulting.ch.selenium.framework.screenshot.utils.file.UnableSaveSnapshotException;
import seleniumConsulting.ch.selenium.framework.screenshot.utils.web.UnableTakeSnapshotException;

public class FileUtil {
    public static String getJsScript(String filePath) {
        try {
            InputStream is = Thread.currentThread().getContextClassLoader().getResourceAsStream(filePath);
            if (is == null) {
                is = FileUtil.class.getClassLoader().getResourceAsStream(filePath);
            }
            if (is == null) {
                new UnableTakeSnapshotException("Unable to load JS script, unable to locate resource stream.");
            }
            return IOUtils.toString((InputStream)is);
        }
        catch (IOException e) {
            throw new UnableTakeSnapshotException("Unable to load JS script", e);
        }
    }

    public static void writeImage(BufferedImage imageFile, String extension, String fileToWriteTo) {
        FileUtil.writeImage(imageFile, extension, new File(fileToWriteTo));
    }

    public static void writeImage(BufferedImage imageFile, String extension, File fileToWriteTo) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            ImageIO.write((RenderedImage)imageFile, "png", baos);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        byte[] bytes = baos.toByteArray();
        AllureUtils.addPngAttachment(fileToWriteTo.getName(), bytes);
        try {
            ImageIO.write((RenderedImage)imageFile, extension, fileToWriteTo);
        }
        catch (IOException e) {
            throw new UnableSaveSnapshotException(e);
        }
    }

    public static BufferedImage getImage(String filePath) {
        try {
            BufferedImage img = ImageIO.read(new File(filePath));
            return img;
        }
        catch (IOException e) {
            throw new UnableGetImageException(filePath, e);
        }
    }
}

