/*
 * Decompiled with CFR 0.152.
 */
package seleniumConsulting.ch.selenium.framework.screenshot.utils.image.model;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.File;
import seleniumConsulting.ch.selenium.framework.allure.AllureUtils;
import seleniumConsulting.ch.selenium.framework.screenshot.utils.file.FileUtil;

public class ImageData {
    public static final int IMG_TITLE_HEIGHT = 50;
    public static final int IMAGE_SEPARATOR_WIDTH = 2;
    public static final int IMAGE_SEPARATOR_HEIGHT = 2;
    private final int RED_RGB = new Color(255, 0, 0).getRGB();
    public static final Color BLUE_BORDER_COLOR = new Color(81, 203, 238, 128);
    private final BufferedImage image;
    private final int width;
    private final int height;

    public ImageData(BufferedImage image) {
        this.image = image;
        this.width = image.getWidth(null);
        this.height = image.getHeight(null);
    }

    public boolean notEqualsDimensions(ImageData imageData) {
        return !this.equalsDimensions(imageData);
    }

    private boolean equalsDimensions(ImageData imageData) {
        return this.width == imageData.width && this.height == imageData.height;
    }

    public boolean equalsEachPixelsWithCreateDifferencesImage(ImageData imageData, double deviation, String pathDifferenceImageFileName) {
        return this.equalsEachPixelsWithCreateDifferencesImage(imageData.getImage(), deviation, pathDifferenceImageFileName);
    }

    private boolean equalsEachPixelsWithCreateDifferencesImage(BufferedImage image, double deviation, String pathDifferenceImageFileName) {
        boolean isEqual = this.equalsEachPixels(image, deviation);
        if (!isEqual) {
            this.createDifferencesImage(image, pathDifferenceImageFileName);
        }
        return isEqual;
    }

    private void createDifferencesImage(BufferedImage image, String pathDifferenceImageFileName) {
        BufferedImage output = new BufferedImage(this.width * 2 + 2, this.height + 50, 1);
        Graphics2D graphics2D = output.createGraphics();
        graphics2D.setColor(Color.WHITE);
        graphics2D.fillRect(0, 0, this.width * 2 + 2, 50);
        graphics2D.setColor(Color.BLACK);
        graphics2D.setFont(new Font("default", 1, 16));
        graphics2D.drawString("Reverence", this.width / 2 - 10, 25);
        graphics2D.drawString("Current", this.width + this.width / 2 - 10, 25);
        graphics2D.drawImage((Image)image, 0, 50, null);
        for (int y = 0; y < this.height; ++y) {
            for (int x = 0; x < this.width; ++x) {
                int rgb2;
                int rgb1 = this.getImage().getRGB(x, y);
                if (rgb1 == (rgb2 = image.getRGB(x, y))) continue;
                this.getImage().setRGB(x, y, this.RED_RGB & rgb1);
            }
        }
        graphics2D.drawImage((Image)this.getImage(), this.width + 2, 50, null);
        graphics2D.fillRect(this.width, 0, 2, this.height + 50);
        graphics2D.fillRect(0, 48, this.width * 2 + 2, 2);
        FileUtil.writeImage(output, "png", new File(pathDifferenceImageFileName + ".png"));
        AllureUtils.setTestHasScreenshotDiffError(true);
    }

    public boolean equalsEachPixels(ImageData imageData, double deviation) {
        return this.equalsEachPixels(imageData.getImage(), deviation);
    }

    private boolean equalsEachPixels(BufferedImage image, double deviation) {
        double p = this.calculatePixelsDifference(image);
        return p == 0.0 || p <= deviation;
    }

    private double calculatePixelsDifference(BufferedImage image) {
        long diff = 0L;
        for (int y = 0; y < this.height; ++y) {
            for (int x = 0; x < this.width; ++x) {
                int rgb1 = this.getImage().getRGB(x, y);
                int rgb2 = image.getRGB(x, y);
                int r1 = rgb1 >> 16 & 0xFF;
                int g1 = rgb1 >> 8 & 0xFF;
                int b1 = rgb1 & 0xFF;
                int r2 = rgb2 >> 16 & 0xFF;
                int g2 = rgb2 >> 8 & 0xFF;
                int b2 = rgb2 & 0xFF;
                diff += (long)Math.abs(r1 - r2);
                diff += (long)Math.abs(g1 - g2);
                diff += (long)Math.abs(b1 - b2);
            }
        }
        double n = this.width * this.height * 3;
        return (double)diff / n / 255.0;
    }

    public BufferedImage getImage() {
        return this.image;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }
}

