package seleniumConsulting.ch.selenium.framework.annotation;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

@Retention(RetentionPolicy.RUNTIME)
@Target({ElementType.METHOD})
public @interface WebTest {
    /**
     * Define your Browser-String-Array
     * Browsers = {android, chrome, firefox, htmlunit, internet explorer, iPhone, iPad, opera, safari} or nothing to define in data.properties
     * Optional: You are able to define the Version after the Browser
     * e.g. browser={"browser=internet explorer", "browser=firefox"} or browser={"browser=internet explorer&amp;version=11", "browser=firefox&amp;version=50"}
     */
    String[] browser() default {};
    /**
     * Define your Browser-Capibilities
     * capibilities = {"javascriptEnabled=true", "databaseEnabled=true"}
     * This will add this Capibilities to the testconfig/data.properties and set it to the Browser
     * See: https://github.com/SeleniumHQ/selenium/wiki/DesiredCapabilities
     */
    String[] capibilities() default {};

}
