package seleniumConsulting.ch.selenium.framework.listeners.webdriver;

import java.text.MessageFormat;
import java.util.Arrays;

import org.openqa.selenium.*;
import org.openqa.selenium.remote.Augmentable;
import org.openqa.selenium.remote.Augmenter;
import org.openqa.selenium.support.events.AbstractWebDriverEventListener;

import io.qameta.allure.Attachment;
import io.qameta.allure.model.Parameter;
import seleniumConsulting.ch.selenium.framework.allure.AllureTextEnum;
import seleniumConsulting.ch.selenium.framework.allure.AllureUtils;
import seleniumConsulting.ch.selenium.framework.dataLoader.TestDataProvider;
import seleniumConsulting.ch.selenium.framework.driver.WebDriverManager;


public class WebDriverEventListener extends AbstractWebDriverEventListener {

    public static final String VALUE = "value";
    public static final String TYPE = "type";
    public static final String TYPE_PASSWORD = "password";

    By by;

    String message = "";

    public WebDriverEventListener() {
    }

    public void beforeClickOn(WebElement element, WebDriver driver) {
        AllureUtils.startStep(MessageFormat.format(TestDataProvider.getTestData(AllureTextEnum.Click), by.toString()), new Parameter().setName("element").setValue(element.toString()));
        addHighlightElement(element, driver, "Click");
        takeScreenshot(TestDataProvider.getTestData(AllureTextEnum.ScreenshotClick));
        removeHighlightElement(driver);
    }

    public void afterClickOn(WebElement element, WebDriver driver) {
        AllureUtils.stopStepPassed();
    }

    public void beforeFindBy(By by, WebElement element, WebDriver driver) {
        this.by = by;
    }

    public void beforeChangeValueOf(WebElement element, WebDriver driver, CharSequence[] keysToSend) {
        if(element.getTagName().equalsIgnoreCase("input")) {
            String oldValue = element.getAttribute(VALUE);
            String newValue = Arrays.toString(keysToSend);
            if (element.getAttribute(TYPE).equals(TYPE_PASSWORD)) {
                oldValue = "**********";
                newValue = "**********";
            }
            message = MessageFormat.format(TestDataProvider.getTestData(AllureTextEnum.ValueChange), oldValue, newValue);
            AllureUtils.startStep(message, new Parameter().setName("element").setValue(element.toString()));
        } else {

            message = MessageFormat.format(TestDataProvider.getTestData(AllureTextEnum.SendKeys), keysToSend);
            AllureUtils.startStep(message, new Parameter().setName("element").setValue(element.toString()));
        }
    }

    public void afterChangeValueOf(WebElement element, WebDriver driver, CharSequence[] keysToSend) {
        addHighlightElement(element, driver, message);
        takeScreenshot(TestDataProvider.getTestData(AllureTextEnum.ScreenshotValueChange));
        removeHighlightElement(driver);
        AllureUtils.stopStepPassed();
        message = "";
    }

    private void addHighlightElement(WebElement element, WebDriver driver, String message) {
        //TODO: TimeTracking with Breakpoint
         ((JavascriptExecutor) driver).executeScript(
                "var node = document.createElement(\"div\");\n" +
               "var childnode = document.createElement(\"div\");\n" +
               "var textnode = document.createElement(\"span\");\n" +
                "node.setAttribute('id','seleniumHighlight');\n" +
                "node.style.cssText = 'position: absolute;z-index: 100000;width: '+arguments[2]+'px;top:'+arguments[1]+'px;left: '+arguments[0]+'px';\n" +
                "textnode.style.cssText = 'white-space: nowrap;background: rgba(81, 203, 238, 1) !important';\n" +
                "childnode.style.cssText = 'box-shadow: 0 0 20px rgba(81, 203, 238, 0.5) !important;height: '+arguments[3]+'px;border: 3px solid rgba(81, 203, 238, 0.5) !important;background: rgba(81, 203, 238, 0.5) !important;'\n" +
                "textnode.textContent = arguments[5]+arguments[4];\n" +
                "node.append(textnode);\n" +
                "node.append(childnode);\n" +
                "document.body.append(node);",
                 element.getLocation().x - 10, element.getLocation().y - 12, element.getSize().width+20, element.getSize().height+10, by.toString(), message.isEmpty()?"": message+ ": ");
        // set timeout and remove it
    }
    private void removeHighlightElement(WebDriver driver) {
        ((JavascriptExecutor) driver).executeScript(
                "document.getElementById('seleniumHighlight') != undefined ? document.getElementById('seleniumHighlight').remove() : ''");
    }

    @Attachment(value = "{message}", type = "image/png")
    private byte[] takeScreenshot(String message) {
        TakesScreenshot takesScreenshot = (TakesScreenshot) (WebDriverManager.getWebdriver().getClass().isAnnotationPresent(Augmentable.class) ? (new Augmenter()).augment(WebDriverManager.getWebdriver()) : WebDriverManager.getWebdriver());
        return takesScreenshot.getScreenshotAs(OutputType.BYTES);
    }

}
