package seleniumConsulting.ch.selenium.framework.metadata;

import java.util.HashMap;
import java.util.Map;

import org.testng.IMethodInstance;
import org.testng.ITestNGMethod;

public class MetadataManager {
    /** Map<HashCodeOfITestNGMethod-Description, Map<MetadataKey, Object>>*/
    static Map<Integer, Map<String, Object>> metadataMap = new HashMap();

    public static Object getMetadata(ITestNGMethod mapKey, String key) {
        return getMetadataMap(mapKey).get(key);
    }

    public static void setMetadata(IMethodInstance mapKey, String key, Object object) {
        getMetadataMap(mapKey.getMethod()).put(key, object);
    }

    public static void setMetadata(ITestNGMethod mapKey, String key, Object object) {
        getMetadataMap(mapKey).put(key, object);
    }

    private static Map<String, Object> getMetadataMap(ITestNGMethod mapKey){
        Map map = metadataMap.get(mapKey.getDescription().hashCode());
        if(map == null){
            metadataMap.put(mapKey.getDescription().hashCode(), new HashMap<>());
            map = metadataMap.get(mapKey.getDescription().hashCode());
        }
        return map;
    }

}
