package seleniumConsulting.ch.selenium.framework.allure;

import java.util.*;

import io.qameta.allure.*;
import io.qameta.allure.model.*;

public class AllureUtils {

    private static Map uuidThreadIdMap = new HashMap();

    public static void startStep(String name, Parameter... values){
        Allure.getLifecycle().startStep(createUuid(), new StepResult().setName(name).setParameters(values));
    }
    public static void startStep(String name){
        Allure.getLifecycle().startStep(createUuid(), new StepResult().setName(name));
    }

    public static void stopStepPassed(){
        stopStepWithStatus(Status.PASSED);
    }
    public static void stopStepWithStatus(Status status){
        Allure.getLifecycle().updateStep(getUuid(), (s) -> s.setStatus(status));
        Allure.getLifecycle().stopStep(getUuid());
        delUuid();
    }

    public static void logSuccess(String message){
        logInStatus(message, Status.PASSED);
    }
    public static void logInfo(String message){
        logInStatus(message, Status.PASSED);
    }
    public static void logError(String message){
        logInStatus(message, Status.FAILED);
    }
    private static void logInStatus(String message, Status status){
        startStep(message);
        stopStepWithStatus(status);
    }

    private static String getUuid() {
        return (String) uuidThreadIdMap.get((int) (Thread.currentThread().getId()));
    }

    private static String createUuid(){
        String uuid = UUID.randomUUID().toString();
        uuidThreadIdMap.put((int) (Thread.currentThread().getId()), uuid);
        return uuid;
    }

    private static void delUuid(){
        uuidThreadIdMap.remove((int) (Thread.currentThread().getId()));
    }

}
