package seleniumConsulting.ch.selenium.framework.driver;


import java.util.HashMap;
import java.util.Map;

import org.openqa.selenium.WebDriver;
import org.openqa.selenium.remote.RemoteWebDriver;
import org.openqa.selenium.remote.SessionId;
import org.openqa.selenium.support.events.EventFiringWebDriver;
import org.openqa.selenium.support.events.WebDriverEventListener;
import org.testng.ITestNGMethod;

import static seleniumConsulting.ch.selenium.framework.driver.WebDriverFactory.CAPABILITIES;
import static seleniumConsulting.ch.selenium.framework.metadata.MetadataKey.BROWSERNAME;
import static seleniumConsulting.ch.selenium.framework.metadata.MetadataKey.BROWSERVERSION;
import static seleniumConsulting.ch.selenium.framework.metadata.MetadataManager.getMetadata;


public class WebDriverManager {

    /** Map<ThreadId, WebDriver> */
    private static Map<Long, WebDriver> webDriverMap = new HashMap();
    /** Map<ThreadId, SesseionId> */
    private static Map<Long, SessionId> webDriverSessionIDMap = new HashMap();

    public static WebDriver getWebdriver() {
        return webDriverMap.get(Thread.currentThread().getId());
    }

    public static SessionId getWebdriverSessionId() {
        return webDriverSessionIDMap.get(Thread.currentThread().getId());
    }

    public static WebDriver createWebDriver(ITestNGMethod metakey) {
        // Create Driver
        WebDriver webDriver = WebDriverFactory.createDriver(
            (String)getMetadata(metakey, BROWSERNAME),
            (String)getMetadata(metakey, BROWSERVERSION),
            (Map<String, String>)getMetadata(metakey, CAPABILITIES)
        );

        //Create and register WebDriverEventListener
        EventFiringWebDriver driver = new EventFiringWebDriver(webDriver);
        WebDriverEventListener webDriverEventListener = new seleniumConsulting.ch.selenium.framework.listeners.webdriver.WebDriverEventListener();
        driver.register(webDriverEventListener);

        //Store RemoteWebDriver SessionId if webDriver is instanceOf RemoteWebDriver
        if (webDriver instanceof RemoteWebDriver) {
            webDriverSessionIDMap.put(Thread.currentThread().getId(), ((RemoteWebDriver) webDriver).getSessionId());
        }

        //Store WebDriver
        webDriverMapPut(driver);

        return driver;
    }

    private static synchronized void webDriverMapPut(WebDriver driver){
        webDriverMap.put(Thread.currentThread().getId(), driver);
    }

}
